#!/usr/bin/perl -w
#построение частотного словаря синтаксических структур

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

my %dic_freq;
my %dic_pos;
while (<STDIN>) { #ctg_list_synt_struct
    chomp;
    my ($ctg_name, $word_root, $tree_pos, $tree_words) = split /\t/;

    $dic_freq{$tree_pos}++;
    $dic_pos{$tree_pos} = "$ctg_name\t$word_root\t$tree_words";
}

for my $tree_pos (sort { $dic_freq{$b} <=> $dic_freq{$a} || $a cmp $b } keys %dic_freq) {
    print $dic_freq{$tree_pos}."\t$tree_pos\t".$dic_pos{$tree_pos}."\n";
}
