#!/usr/bin/python
# -*- coding: utf-8 -*-

#разделение эталонной выборки на обучающую и тестовую

import sys
import re
import random
import yt.wrapper as yt


class train_or_test(object): #формирование обучающей и тестовой выборок
    def __init__(self, size):
        self.etalon_size = size[0] #размер эталонной выборки
        self.test_size = size[1] #размер тестовой выборки

    def __call__(self, key, recs):
        num = 0 #число баннеров в категории
        TEST = [] #случайный список номеров баннеров для тестовой выборки
        i = 0 #номер баннера
        j = 0 #текущий индекс баннера для тестовой выборки
        for rec in recs:
            table_index = rec.pop('@table_index')
            if table_index == 0:
                num = -rec['num']
                num_test = int((float(num) * self.test_size) / self.etalon_size + 0.5)
                if num_test == 0:
                    num_test = 1;
                while len(TEST) < num_test:
                    r = random.randint(1, num)
                    if r not in TEST: #без повторов
                        TEST.append(r)
                TEST.sort()
            elif num != 0:
                i += 1
                if j < len(TEST) and i == TEST[j]: #тестовая выборка
                    yield { "bid": rec['bid'], "title": rec['title'], "body": rec['body'], "mctgs": rec['mctgs'], "domain": rec['domain'], "clast_phrase": rec['clast_phrase'], "@table_index": 0 }
                    j += 1
                else:  #обучающая выборка
                    yield { "bid": rec['bid'], "title": rec['title'], "body": rec['body'], "mctgs": rec['mctgs'], "domain": rec['domain'], "title_norm": rec['title_norm'], "body_norm": rec['body_norm'], "@table_index": 1 }


def main():
    tab0 = '//home/catalogia/users/yuryz/contest/etalon' #эталон
    tab1 = '//tmp/yuryz/etalon'

    yt.run_sort(tab0, tab1, sort_by=['mctgs', 'bid'])

    tab2 = '//home/catalogia/users/yuryz/contest/ctg_count'
    tab3 = '//home/catalogia/users/yuryz/contest/test'
    tab4 = '//home/catalogia/users/yuryz/contest/train'

    ETALON_SIZE = yt.row_count(tab1) #размер эталонной выборки
    TEST_SIZE = 500000 #размер тестовой выборки

    yt.run_reduce(train_or_test([ETALON_SIZE, TEST_SIZE]), [tab2, tab1], [tab3, tab4], reduce_by = ['mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab3, sort_by=['bid'])
    yt.run_sort(tab4, sort_by=['bid'])


if __name__ == '__main__':
    main()
