#!/usr/bin/python
# -*- coding: utf-8 -*-

#формирование и выбор эталонов

import sys
import math
import yt.wrapper as yt


def sel_lemm(rec): #первичный выбор лемм из баннера
    L = rec['bnorm'].split()
    wrds = set(L) #удаляем дубли
    #wrds = rec['bnorm'].split()
    for wrd in wrds:
        yield { "word": wrd, "mctgs": rec['mctgs'], "bid": int(rec['bid']) }


def cr_dict_freq(key, recs): #формирование частотного словаря лемм для каждой категории
    freq = 0
    for rec in recs:
        freq += 1
    yield { "mctgs": key['mctgs'], "word": key['word'], "freq": freq }


def prep_etal_rank(key, recs): #подготовка к вычислению ранга эталонности баннеров
    freq = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            freq = rec['freq']
        else:
            rec['freq'] = freq
            yield rec


def calc_etal_rank(key, recs): #вычисление ранга "эталонности" баннеров
    L = []
    for rec in recs:
        L.append(rec['freq'])
    fsum = sum(L)
    size = len(L)

    fact1 = float(fsum) / size #средняя плотность слова в баннере
    fact2 = math.log(size + 1, 2) #длина баннера
    fact3 = 0; #энтропия частот
    for freq in L:
        prob = float(freq) / fsum
        fact3 -= prob * math.log(prob, 2)

    rank = fact1 * fact2 * fact3
    if rank > 0:
        yield { "bid": key['bid'], "rank": '%.2f' % rank }


def bid2num(rec): #преобразование bid в числовой формат
    rec['bid'] = int(rec['bid'])
    yield rec


def count_ctg_size(key, recs): #определение размера категорий
    size = 0
    for rec in recs:
        size += 1
    yield { "mctgs": key['mctgs'], "size": size }


def rank_abs(key, recs): #добавление абсолютного ранга
    rank = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            rank = -float(rec['rank'])
        else:
            if rank != 0:
                rec['rank'] = rank
                yield rec


def rank_rel(key, recs): #добавление относительного ранга
    flag = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            size = rec['size']
        else:
            if flag == 0:
                flag = 1
                rank_max = rec['rank']
            rank_rel = '%.3f' % (-rec['rank'] / rank_max)
            rec['rank_rel'] = float(rank_rel)
            rec['size'] = -size
            yield rec


def prep_bnrs_etalon(key, recs): #подготовка эталонных баннеров
    mctgs = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            mctgs = rec['mctgs']
        else:
            if mctgs != '':
                yield { "mctgs": rec['mctgs'], "bid": rec['bid'], "title": rec['title'], "body": rec['body'], "rank_rel": rec['rank_rel'] }


class final_bnrs_etalon(object): #окончательное формирование эталонных баннеров
    def __init__(self, rank_min):
        self.rank_min = float(rank_min)

    def __call__(self, rec):
        if rec['rank_rel'] <= -self.rank_min:
            yield rec


def main():
    with yt.TempTable() as bnrs_wrd, \
         yt.TempTable() as dict_freq, \
         yt.TempTable() as bnrs_wrds_freq, \
         yt.TempTable() as bnrs_rank, \
         yt.TempTable() as bnrs_norm, \
         yt.TempTable() as bnrs_norm_s, \
         yt.TempTable() as ctg_size, \
         yt.TempTable() as bnrs_rank_abs, \
         yt.TempTable() as bnrs_rank_rel_s, \
         yt.TempTable() as bnrs_etalon:

        print >> sys.stderr, "Этап 1. Первичный выбор лемм из баннера"
        yt.run_map(sel_lemm, sys.argv[1], bnrs_wrd)
        yt.run_sort(bnrs_wrd, sort_by=['mctgs', 'word'])

        print >> sys.stderr, "Этап 2. Формирование частотного словаря лемм для каждой категории"
        yt.run_reduce(cr_dict_freq, bnrs_wrd, dict_freq, reduce_by=['mctgs', 'word'])
        yt.run_sort(dict_freq, sort_by=['mctgs', 'word'])

        print >> sys.stderr, "Этап 3. Подготовка к вычислению ранга эталонности баннеров"
        yt.run_reduce(prep_etal_rank, [dict_freq, bnrs_wrd], bnrs_wrds_freq, reduce_by = ['mctgs', 'word'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
        yt.run_sort(bnrs_wrds_freq, sort_by=['bid'])

        print >> sys.stderr, "Этап 4. Вычисление ранга эталонности баннеров"
        yt.run_reduce(calc_etal_rank, bnrs_wrds_freq, bnrs_rank, reduce_by = ['bid'])
        yt.run_sort(bnrs_rank, sort_by=['bid'])

        print >> sys.stderr, "Этап 5. Определение размера категорий"
        yt.run_map(bid2num, sys.argv[1], bnrs_norm)
        yt.run_sort(bnrs_norm, sys.argv[1], sort_by=['bid'])

        yt.run_sort(sys.argv[1], bnrs_norm_s, sort_by=['mctgs'])
        yt.run_reduce(count_ctg_size, bnrs_norm_s, ctg_size, reduce_by=['mctgs'])
        yt.run_sort(ctg_size, sort_by=['mctgs'])

        print >> sys.stderr, "Этап 6. Добавление абсолютного и относительного рангов"
        yt.run_reduce(rank_abs, [bnrs_rank, sys.argv[1]], bnrs_rank_abs, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
        yt.run_sort(bnrs_rank_abs, sort_by=['mctgs', 'rank'])

        yt.run_reduce(rank_rel, [ctg_size, bnrs_rank_abs], bnrs_rank_rel_s, reduce_by = ['mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
        yt.run_sort(bnrs_rank_rel_s, sort_by=['mctgs', 'rank_rel', 'bid'])

        print >> sys.stderr, "Этап 7. Формирование и отбор эталонных баннеров"
        yt.run_reduce(prep_bnrs_etalon, [sys.argv[2], bnrs_rank_rel_s], bnrs_etalon, reduce_by = ['mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
        yt.run_sort(bnrs_etalon, sort_by=['rank_rel', 'bid'])

        yt.run_map(final_bnrs_etalon(sys.argv[4]), bnrs_etalon, sys.argv[3])
        yt.run_sort(sys.argv[3], sort_by=['rank_rel', 'bid'])


if __name__ == '__main__':
    main()
