#!/usr/bin/python
# -*- coding: utf-8 -*-

#статистика блоков различных размеров

import random
import sys
import re
import yt.wrapper as yt


def sel_block_size(rec): #выбор размеров блоков
    yield { "mctgs": rec['mctgs'], "block_index": rec['block_index'], "size": rec['size'] }


def del_dup(key, recs): #удаление дублей
    yield recs.next()


def size_count(key, recs): #подсчет количества блоков одинакового размера
    freq = 0
    for rec in recs:
        freq += 1
    yield { "size": key['size'], "freq": freq  }


def blk_size4markup(key, recs): #статистика размеров блоков для ручной разметки (только по реальным исправлениям)
    bid = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            bid = rec['bid']
            block_index = rec['block_index']
            size = rec['size']
            sense = rec['sense']
        elif bid != 0:
            if rec['mctgs'] != rec['CategoryNames']:
                rec['block_index'] = block_index
                rec['size_before'] = size
                rec['sense'] = sense
                yield rec


class bnrs_sel(object): #случайный выбор баннеров из блоков
    def __init__(self, prob):
        self.prob = prob

    def __call__(self, rec):
        if random.uniform(0, self.prob) < 1: #вероятность = 1 / prob
            yield rec


def block_cross(key, recs): #пересечение размеченных блоков и случайной выборки
    mctgs = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            mctgs = key['mctgs']
            block_index = key['block_index']
            sense = rec['sense']
        elif mctgs != '':
            rec['sense2'] = sense
            yield rec
            return ##############


def block_cross_total(key, recs): #пересечение размеченных блоков и всей Каталогии
    mctgs = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            mctgs = key['mctgs']
            block_index = key['block_index']
            size = rec['size']
        elif mctgs != '':
            rec['size'] = -size
            yield rec


def main():
    tab1 = '//home/catalogia/users/yuryz/etalon/.quarantine/block_sens_num'
    tab2 = '//tmp/yuryz/block2size'

    #yt.run_map(sel_block_size, tab1, [tab2], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab2, sort_by=['mctgs', 'block_index', 'size'])

    tab3 = '//tmp/yuryz/block2size_uniq'

    #yt.run_reduce(del_dup, tab2, tab3, reduce_by = ['mctgs', 'block_index', 'size'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    ##yt.run_sort(tab3, sort_by=['size', 'mctgs', 'block_index'])
    #yt.run_sort(tab3, sort_by=['mctgs', 'block_index', 'size'])

    tab4 = '//tmp/yuryz/block_size_freq'

    #yt.run_reduce(size_count, tab3, tab4, reduce_by = ['size'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab4, sort_by=['size', 'freq'])

    # --- Статистика размеров блоков для ручной разметки (только по реальным исправлениям) ---
    tab5 = '//home/catalogia/users/yuryz/etalon/marked_dataset_irt_checked'
    tab6 = '//tmp/yuryz/blk_size4markup'

    #yt.run_reduce(blk_size4markup, [tab1, tab5], tab6, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab6, sort_by=['mctgs', 'block_index', 'size_before', 'bid'])

    #--- Случайный выбор баннеров из блоков ---
    tab7 = '//tmp/yuryz/block_sens_num'

    BNRS4TEST = 5000000.0 #число баннеров для тестирования
    prob = yt.row_count(tab1) / BNRS4TEST #вероятность выбора баннеров

    #yt.run_map(bnrs_sel(prob), tab1, tab7)
    #yt.run_sort(tab7, sort_by=['mctgs', 'block_index', 'bid'])

    # --- Пересечение блоков с ручной разметкой и случайно выбранных для разметки асессорами ---
    tab8 = '//tmp/yuryz/block_cross'

    ##yt.run_reduce(block_cross, [tab6, tab7], tab8, reduce_by = ['mctgs', 'block_index'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    ##yt.run_sort(tab8, sort_by=['mctgs', 'block_index', 'bid'])
    #yt.run_reduce(block_cross_total, [tab3, tab6], tab8, reduce_by = ['mctgs', 'block_index'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab8, sort_by=['size', 'mctgs', 'block_index', 'CategoryNames', 'sense', 'title', 'body'])


if __name__ == '__main__':
    main()
