#!/usr/bin/python
# -*- coding: utf-8 -*-

#выделение смысловой структуры баннеров и формирование семантических блоков

import sys
import re
import math

import yt.wrapper as yt

def bnr_domain_insert(key, recs): #вставка домена в баннер
    bid = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            bid = rec['bid']
            domain = rec['domain']
        elif bid != 0:
            del rec['clast_phrase']
            del rec['trash']
            del rec['clast_weight']
            rec['domain'] = domain

            yield rec


def sense_select(rec): #выделение смысловой структуры баннеров
    L = rec['sense'].split()
    S = []
    for i in range(0, len(L), 2): #веса не учитываем
        S.append(L[i])

    sense = ' '.join(S)
    yield { "bid": rec['bid'], "mctgs": rec['mctgs'], "sense": sense, "domain": rec['domain'] }


def num_insert(rec): #вставка индекса в таблицу
    rec["row_index"] = rec["@row_index"]
    del rec["@row_index"]

    yield rec


def bnrs_sens_range(key, recs): #формирование диапазонов индексов
    ind_prev = -1
    size = 0
    for rec in recs:
        if ind_prev == -1:
            ind_prev = rec['row_index']
            size = 1
        elif ind_prev == rec['row_index'] - 1: #соседние индексы
            ind_prev += 1
            size += 1
        else:
            yield { "mctgs": key['mctgs'], "row_index_max": ind_prev, "size": size }

            ind_prev = rec['row_index']
            size = 1
    yield { "mctgs": key['mctgs'], "row_index_max": ind_prev, "size": size }


def bnrs_block_insert(key, recs): #вставка размера блока
    row_index_max = []
    size = []
    i = 0 #индекс блока
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            row_index_max.append(rec['row_index_max'])
            size.append(rec['size'])
        else:
            if rec['row_index'] > row_index_max[i]:
                i += 1
            rec['block_index'] = i
            rec['size'] = size[i]
            yield rec


def main():
    #--- 0. Вставка домена для баннера ---
    tab0 = '//home/catalogia/users/yuryz/tmp/bnrs_norm'
    tab1 = '//home/catalogia/users/yuryz/tmp/bnr2tf_idf'
    tab1a = '//tmp/yuryz/bnr2tf_idf'

    yt.run_reduce(bnr_domain_insert, [tab0, tab1], tab1a, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))

    #--- 1. Выделение смысловой структуры баннеров ---
    tab2 = '//home/catalogia/users/yuryz/etalon/bnr_sense'

    yt.run_map(sense_select, tab1a, tab2, format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab2, sort_by=['sense', 'mctgs', 'bid'], job_io={"table_writer":{"max_key_weight":131072}})

    #--- 2. Вставка индекса в таблицу ---
    tab3 = '//home/catalogia/users/yuryz/etalon/bnr_sense_num'

    yt.run_map(num_insert, tab2, tab3, job_io={"control_attributes": {"enable_row_index": True}}, format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab3, sort_by=['mctgs', 'row_index', 'sense', 'bid'], job_io={"table_writer":{"max_key_weight":131072}})

    #--- 3. Формирование диапазонов индексов ---
    tab4 = '//tmp/yuryz/bnrs_sens_range'

    yt.run_reduce(bnrs_sens_range, tab3, tab4, reduce_by = ['mctgs'])
    yt.run_sort(tab4, sort_by=['mctgs', 'row_index_max', 'size'], job_io={"table_writer":{"max_key_weight":131072}})

    #--- 4. Вставка размера блока ---
    tab5 = '//home/catalogia/users/yuryz/etalon/block_sens_num'

    yt.run_reduce(bnrs_block_insert, [tab4, tab3], tab5, reduce_by = ['mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab5, sort_by=['row_index', 'size', 'sense', 'mctgs', 'bid'], job_io={"table_writer":{"max_key_weight":131072}})


if __name__ == '__main__':
    main()
