#!/usr/bin/python
# -*- coding: utf-8 -*-

#подготовка к вычислению ранга "эталонности" баннеров

import yt.wrapper as yt


def reducer(key, recs):
    freq = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            freq = rec['freq']
        else:
            rec['freq'] = freq
            yield rec


def main():
    input_1 = '//home/catalogia/users/yuryz/etalon/dict_freq'
    input_2 = '//home/catalogia/users/yuryz/etalon/bnrs_wrd'
    output = '//home/catalogia/users/yuryz/etalon/bnrs_wrds_freq'

    yt.run_reduce(reducer, [input_1, input_2], output, reduce_by = ['mctgs', 'word'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(output, sort_by=['bid'])

    print yt.row_count(input_1)
    print yt.row_count(input_2)
    print yt.row_count(output)


if __name__ == '__main__':
    main()
