#!/usr/bin/python
# -*- coding: utf-8 -*-

#первичный выбор баннеров из BANNERS_EXTENDED

import sys
import re
import yt.wrapper as yt

from urlparse import urlparse


def bnrs_sync(key, recs): #синхронизация Ксюшиной разметки с banners_extended
    bid = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            bid = rec['bid']
            ctg = rec['CategoryNames']
        elif bid != 0:
            yield { "bid": rec['bid'], "title": rec['title'], "body": rec['body'], "CategoryNames": ctg, "mctgs": rec['mctgs'], "domain": rec['domain'], "title_extension": rec['title_extension'], "phrases": rec['phrases'] }


class bnrs_select(object): #выбор баннеров
    def __init__(self, bnr_type):
        self.bnr_type = bnr_type # 1 - обычные баннеры, 2 - омонимичные баннеры, 3 - те и другие

    def __call__(self, rec):
        if rec['mctgs'] and rec['mctgs'] != '' and rec['title'] and rec['title'] != '' and rec['body'] and rec['body'] != '':
            slash = rec['mctgs'].find('/')
            if self.bnr_type == 1 and slash == -1 or self.bnr_type == 2 and slash > 0 or self.bnr_type == 3:
                phrases = ''
                if rec['phrases'] and rec['phrases'] != '':
                    phrs = rec['phrases'].split(',') #фразы
                    uniq = {}
                    for phr in phrs:
                        words = phr.split(' ') #слова фразы
                        for word in words:
                            if re.search(r'^\-', word): #минус-слова
                                continue
                            word = re.sub(r'~0$', '', word)
                            word = re.sub(r':.+$', '', word) #статистика
                            #word = re.sub(r'^\+', '', word)
                            if word not in uniq:
                                uniq[word] = 1

                    L = uniq.keys()
                    L.sort()
                    phrases = ' '.join(L) #уникальные слова всех фраз

                ctgs = rec['mctgs'].split('/') #несколько категорий считаются РАЗНЫМИ категориями
                #ctgs = rec['mctgs'].split('\t') #несколько категорий считаются ОДНОЙ категорией ('\t' - фиктивный разделитель)
                for ctg in ctgs:
                    yield { "bid": rec['bid'], "title": rec['title'], "body": rec['body'], "mctgs": ctg, "domain": rec['domain'], "title_extension": rec['title_extension'], "phrases": rec['phrases'] }


def del_dup(key, recs): #у дублей оставляем только первые записи
    L_ksu = [] #Ксюшина разметка
    L_cat = [] #разметка каталогии
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            L_ksu.append(rec)
        else:
            L_cat.append(rec)
            break

    if len(L_ksu) > 0:
        for rec in L_ksu:
            del rec['CategoryNames']
            ctgs = rec['mctgs'].split('/') #несколько категорий считаются РАЗНЫМИ категориями
            for ctg in ctgs:
                rec['mctgs'] = ctg
                yield rec
    else:
        yield L_cat[0]


def main():
    tab1 = '//home/multik/labelling/marked_dataset_irt_checked' #Ксюшина разметка
    tab2 = '//tmp/yuryz/marked_dataset_irt_checked'

    #yt.run_sort(tab1, tab2, sort_by=['bid'])

    tab3 = '//home/catalogia/banners_extended'
    tab4 = '//home/catalogia/users/yuryz/etalon/marked_dataset_irt_checked' #синхронизированные с banners_extended баннеры

    #yt.run_reduce(bnrs_sync, [tab2, tab3], tab4, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab4, sort_by=['title', 'body', 'mctgs', 'bid'])

    tab6 = '//home/catalogia/users/yuryz/etalon/bnrs_select'

    #yt.run_map(bnrs_select(3), tab3, tab6) # 1 - обычные баннеры, 2 - омонимичные баннеры, 3 - те и другие
    #yt.run_sort(tab6, sort_by=['title', 'body', 'mctgs', 'bid'])

    tab7 = '//home/catalogia/users/yuryz/etalon/bnrs_select_uniq'

    yt.run_reduce(del_dup, [tab4, tab6], tab7, reduce_by=['title', 'body', 'mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))


if __name__ == '__main__':
    main()
