#!/usr/bin/python
# -*- coding: utf-8 -*-

#вставка номера в таблицу
# https://wiki.yandex-team.ru/yt/userdoc/pythonwrapper/#primeryispolzovanija

import sys
import re
import yt.wrapper as yt


def num_insert(rec):
    rec["row_index"] = rec["@row_index"]
    del rec["@row_index"]

    yield rec


def main():
    tab1 = '//home/catalogia/users/yuryz/etalon/bnr_sense'
    tab2 = '//home/catalogia/users/yuryz/etalon/bnr_sense_num'

    yt.run_map(num_insert, tab1, tab2, job_io={"control_attributes": {"enable_row_index": True}}, format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab2, sort_by=['row_index', 'sense', 'mctgs', 'bid'])

    print yt.row_count(tab1)
    print yt.row_count(tab2)


if __name__ == '__main__':
    main()
