#!/usr/bin/python
# -*- coding: utf-8 -*-

#формирование списков категорий Каталогии с разным уровнем качества категоризации

import sys
import re
import yt.wrapper as yt


class bid_join(object):
    def __init__(self, thold_dic):
        self.thold_dic = thold_dic ##словарь MIN порогов для категорий

    def __call__(self, key, recs):
        bid = 0
        bnrs = []
        for rec in recs:
            table_index = rec.pop('@table_index')
            if table_index == 0:
                bid = rec['bid']
                ctgs_checked = rec['CategoryNames'].split('/')
                ctgs_checked = set(ctgs_checked)
                ctgs_checked = sorted(ctgs_checked)
                ctgs_checked = '/'.join(ctgs_checked)
            elif bid != 0:
                bnrs.append(rec) #у блока м.б. несколько категорий

        #анализируем вхождение размеченной категории в список категорий блока
        if len(bnrs) > 0:
            ctgs = ctgs_checked.split('/') #для частичного совпадения
            for i in range(len(bnrs)):
                j = i
                mctgs = bnrs[j]['mctgs'].split('/')
                mctgs = set(mctgs)
                mctgs = sorted(mctgs)
                bnrs[j]['mctgs'] = '/'.join(mctgs)

                ctg_guess = bnrs[j]['mctgs']
                guess = 'NO'

                """
                #--- частичное совпадение ---
                for ctg in mctgs: #частичное совпадение
                    if ctg in ctgs:
                        ctg_guess = ctg
                        guess = 'YES'
                        break
                """

                #--- полное совпадение ---
                if bnrs[j]['mctgs'] == ctgs_checked: #полное совпадение
                    guess = 'YES'
                    break

            bnrs[j]['checked'] = guess

            #if bnrs[j]['size'] >= 100: #единый порог для размера блока ДЛЯ ВСЕХ категорий
            if ctg_guess in self.thold_dic and bnrs[j]['size'] >= self.thold_dic[ctg_guess]: #ИНДИВИДУАЛЬНЫЕ пороги по каждой из размеченных категорий
                yield bnrs[j]


def main():
    THOLD = 0.95 #MIN точность при выборе порога категорий (0.00 - baseline)

    thold_dic = {} #словарь MIN порогов для категорий
    f = open('ctg_thold', 'r') #python sel_checked_bnrs.py | LC_ALL=C sort -t$'\t' -k1,1 -k2,2n >ctg_thold
    while True:
        line = f.readline()
        if len(line) == 0: break

        line = line.rstrip('\n')
        mctgs, size, total, guess, prob = line.split('\t')

        ctgs = mctgs.split('/')
        ctgs = set(ctgs)
        ctgs = sorted(ctgs)
        ctgs = '/'.join(ctgs)

        #--- нестрогое разделение ---
        if float(prob) >= 0 and float(prob) < 0.5: #very_bad
        #if float(prob) >= 0.5 and float(prob) < 0.75: #bad
        #if float(prob) >= 0.75 and float(prob) < 0.95: #good
        #if float(prob) >= 0.95 and float(prob) <= 1.0: #very_good
            if ctgs not in thold_dic: #ПЕРВАЯ запись, удовлетворяющая пороговому требованию
                thold_dic[ctgs] = int(size)
                print ctgs + '\t' + str(prob)

        """
        #--- строгое разделение ---
        if ctgs not in thold_dic: #ПЕРВАЯ запись, удовлетворяющая пороговому требованию
            thold_dic[ctgs] = int(size)

            #if float(prob) >= 0 and float(prob) < 0.5: #very_bad
            #if float(prob) >= 0.5 and float(prob) < 0.75: #bad
            #if float(prob) >= 0.75 and float(prob) < 0.95: #good
            if float(prob) >= 0.95 and float(prob) <= 1.0: #very_good
                print ctgs + '\t' + str(prob)
        """

    tab1 = '//home/catalogia/users/yuryz/etalon/marked_dataset_irt_checked'
    tab2 = '//tmp/yuryz/marked_dataset_irt_checked'

    #yt.run_sort(tab1, tab2, sort_by=['bid'])

    tab3 = '//home/catalogia/users/yuryz/etalon/block_sens_num'
    tab4 = '//tmp/yuryz/block_sens_num'

    #yt.run_sort(tab3, tab4, sort_by=['bid'])

    tab5 = '//tmp/yuryz/bnrs_etalon_checked'

    #yt.run_reduce(bid_join(thold_dic), [tab2, tab4], tab5, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))

    """
    yes = 0
    ctgs_list = {} #выбранные категории
    for rec in yt.read_table(tab5, raw=False):
        if rec['checked'] == 'YES': yes += 1
        ctgs_list[rec['mctgs']] = 1

    print 'Порог эталонной разметки (THOLD)=' + str(THOLD)
    print 'Размер словаря (число категорий)=' + str(len(thold_dic))

    print 'Эталон=' + str(yt.row_count(tab2))
    print 'Исходная выборка=' + str(yt.row_count(tab4))
    print 'Пересечений=' + str(yt.row_count(tab5))

    print 'Угадано=' + str(yes)
    print 'Точность эталона=' + '%.3f' % (float(yes) / yt.row_count(tab5))
    """


if __name__ == '__main__':
    main()
