#!/usr/bin/python
# -*- coding: utf-8 -*-

#вычисление размера категорий

import yt.wrapper as yt


def ctg_size(key, recs): #определение размера категорий
    size = 0
    for rec in recs:
        size += 1
    yield { "mctgs": key['mctgs'], "size": size }


def main():
    input = '//home/catalogia/users/yuryz/etalon/bnrs_norm_s'
    output = '//home/catalogia/users/yuryz/etalon/ctg_size'

    yt.run_reduce(ctg_size, input, output, reduce_by=['mctgs'])
    yt.run_sort(output, sort_by=['mctgs'])

    print yt.row_count(input)
    print yt.row_count(output)


if __name__ == '__main__':
    main()
