#!/usr/bin/python
# -*- coding: utf-8 -*-

#формирование частотного словаря лемм для каждой категории

import yt.wrapper as yt


def dict_freq(key, recs): #составление частотного словаря
    freq = 0
    for rec in recs:
        freq += 1
    yield { "mctgs": key['mctgs'], "word": key['word'], "freq": freq }


def main():
    input = '//home/catalogia/users/yuryz/etalon/bnrs_wrd'
    output = '//home/catalogia/users/yuryz/etalon/dict_freq'

    yt.run_reduce(dict_freq, input, output, reduce_by=['mctgs', 'word'])
    yt.run_sort(output, sort_by=['mctgs', 'word'])

    print yt.row_count(input)
    print yt.row_count(output)


if __name__ == '__main__':
    main()
