#!/usr/bin/python
# -*- coding: utf-8 -*-

#формирование эталона на основе семантических блоков

import yt.wrapper as yt


def sel_triad(key, recs): #выбор трех представителей от каждого блока (крайних и среднего)
    rec_low = recs.next()
    size = rec_low['size']
    if size < 15: return #MIN размер семантического блока
    #yield rec_low #начало блока
    i = 1
    mid = size / 2
    for rec in recs:
        i += 1
        if i == mid:
            yield rec #середина блока
        elif i == size:
            #yield rec #конец блока
            pass


def join_be_sem_blocks(key, recs): #добавляем мультилейблы к семантическим блокам (для применения правил из select_rules.py)
    bid = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0: #'//home/catalogia/banners_extended'
            if rec['mctgs'] and rec['mctgs'] != '':
                bid = rec['bid']
                title = rec['title']
                body = rec['body']
                mctgs = rec['mctgs'].split('/')
                mctgs.sort()
                be_mctgs = '/'.join(mctgs)
        elif bid != 0: #'//home/catalogia/users/yuryz/etalon/bnrs_triad'
            rec['title'] = title
            rec['body'] = body
            rec['mctgs_one'] = rec['mctgs']
            rec['mctgs'] = be_mctgs
            yield rec


def sel_ctgs_marked(key, recs): #фильтрация проверенных категорий (оставляем в эталоне только категории, входящие в 28 тыс.)
    bid = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            bid = rec['bid']
        elif bid != 0:
            yield rec


def rules4ctgs(key, recs): #применение правил для категорий
    mctgs = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0: #правила для категорий
            mctgs = rec['mctgs']
            CategoryNames = rec['CategoryNames']
        elif mctgs != '':
            rec['CategoryNames'] = CategoryNames
            rec['rule'] = 1
            yield rec
        else:
            rec['CategoryNames'] = rec['mctgs']
            rec['rule'] = 0
            yield rec


def rules4blocks(key, recs): #применение правил для блоков
    mctgs = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0: #правила для блоков
            mctgs = rec['mctgs']
            CategoryNames = rec['CategoryNames']
        elif mctgs != '':
            rec['CategoryNames'] = CategoryNames
            rec['rule'] = 1
            yield rec
        else:
            yield rec


def main():
    tab1 = '//home/catalogia/users/yuryz/etalon/block_sens_num'
    tab2 = '//tmp/yuryz/block_sens_num'

    #yt.run_sort(tab1, tab2, sort_by=['mctgs', 'block_index', 'row_index', 'bid', ], job_io={"table_writer":{"max_key_weight":131072}})

    tab3 = '//home/catalogia/users/yuryz/etalon/bnrs_triad'

    #yt.run_reduce(sel_triad, tab2, tab3, reduce_by = ['mctgs', 'block_index'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab3, sort_by=['bid'], job_io={"table_writer":{"max_key_weight":131072}})

    tab4 = '//home/catalogia/banners_extended'
    tab5 = '//tmp/yuryz/block_sens_num_multi'

    #yt.run_reduce(join_be_sem_blocks, [tab4, tab3], tab5, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab5, sort_by=['mctgs', 'block_index'], job_io={"table_writer":{"max_key_weight":131072}})

    # --- пересечение с категориями, входящими в 28 тыс. ---
    tab6 = '//home/catalogia/users/yuryz/etalon/marked_dataset_irt_checked'
    tab7 = '//tmp/yuryz/marked_dataset_irt_checked'

    #yt.run_sort(tab6, tab7, sort_by=['mctgs', 'bid'])

    tab8 = '//tmp/yuryz/block_sens_num_filtered'

    #yt.run_reduce(sel_ctgs_marked, [tab7, tab5], tab8, reduce_by = ['mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab8, sort_by=['mctgs', 'block_index'])
    # --- пересечение с категориями, входящими в 28 тыс. ---

    # --- применение правил для категорий ---
    tab9 = '//home/catalogia/users/yuryz/etalon/rules4ctgs' #окончательно сформированные правила для категорий
    tab10 = '//tmp/yuryz/etalon4ctgs'

    yt.run_reduce(rules4ctgs, [tab9, tab8], tab10, reduce_by = ['mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab10, sort_by=['mctgs', 'block_index', 'bid'], job_io={"table_writer":{"max_key_weight":131072}})

    # --- применение правил для блоков ---
    tab11 = '//home/catalogia/users/yuryz/etalon/rules4blocks' #окончательно сформированные правила для блоков
    tab12 = '//home/catalogia/users/yuryz/etalon/etalon4blocks'

    yt.run_reduce(rules4blocks, [tab11, tab10], tab12, reduce_by = ['mctgs', 'block_index'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab12, sort_by=['bid', 'CategoryNames', 'mctgs', 'mctgs_one'], job_io={"table_writer":{"max_key_weight":131072}})


if __name__ == '__main__':
    main()
