#!/usr/bin/python
# -*- coding: utf-8 -*-

#выбор эталонных баннеров с помощью индивидуальных пороговых значений для размеров семантических блоков

import random
import sys
import re
import yt.wrapper as yt


class etalon_select_prelim(object): #предвариетльный выбор эталонов
    def __init__(self, thold_dic):
        self.thold_dic = thold_dic ##словарь MIN порогов для категорий

    def __call__(self, rec):
        if rec['mctgs'] in self.thold_dic and rec['size'] >= self.thold_dic[rec['mctgs']]:
            yield rec


class random_select(object): #случайная выборка нужного объема
    def __init__(self, range_prob):
        self.range_prob = range_prob #диапазон для вычисления вероятности

    def __call__(self, key, recs):
        bid = 0
        for rec in recs:
            table_index = rec.pop('@table_index')
            if table_index == 0:
                bid = rec['bid']
                #mctgs = rec['mctgs']
            elif bid != 0:
                if random.uniform(0, self.range_prob) < 1: #вероятность выбора баннера = 1 / range_prob
                    #rec['CategoryNames'] = mctgs
                    yield rec


def main():
    THOLD = 0.95 #MIN точность при выборе порога категорий (0.00 - baseline)

    thold_dic = {} #словарь MIN порогов для категорий
    f = open('ctg_thold', 'r') #python sel_checked_bnrs.py | LC_ALL=C sort -t$'\t' -k1,1 -k2,2n >ctg_thold
    while True:
        line = f.readline()
        if len(line) == 0: break

        line = line.rstrip('\n')
        mctgs, size, total, guess, prob = line.split('\t')

        ctgs = mctgs.split('/')
        ctgs = set(ctgs)
        ctgs = sorted(ctgs)
        ctgs = '/'.join(ctgs)

        if float(prob) >= THOLD:
            if ctgs not in thold_dic: #ПЕРВАЯ запись, удовлетворяющая пороговому требованию
                thold_dic[ctgs] = int(size)

    tab1 = '//home/catalogia/users/yuryz/etalon/block_sens_num'
    tab2 = '//tmp/yuryz/etalon_full_list'

    #yt.run_map(etalon_select_prelim(thold_dic), tab1, tab2, format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab2, tab2, sort_by=['bid'])

    tab3 = '//home/catalogia/banners_extended'
    tab4 = '//home/catalogia/users/yuryz/etalon/etalon_sample'

    range_prob = yt.row_count(tab2) / int(sys.argv[1]) #диапазон для вычисления вероятности (argv[1] - требуемый размер выборки)

    yt.run_reduce(random_select(range_prob), [tab2, tab3], tab4, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    ##yt.run_sort(tab4, sort_by=['bid', 'title', 'body', 'mctgs', 'CategoryNames'])
    yt.run_sort(tab4, sort_by=['bid', 'title', 'body', 'mctgs'])


if __name__ == '__main__':
    main()
