#!/usr/bin/python
# -*- coding: utf-8 -*-

#индексы блоков для Test и TrainExact

import sys
import re
import yt.wrapper as yt


def bids_join(key, recs):
    bid = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            bid = rec['bid']
            yield rec #etalon_blocks_multi
        elif bid == 0:
            yield rec #etalon_new2


def main():
    tab1 = '//tmp/yuryz/etalon_blocks_multi'
    tab2 = '//home/catalogia/users/yuryz/etalon/etalon_new2'
    tab3 = '//home/catalogia/users/yuryz/etalon/etalon_blocks_multi'

    yt.run_reduce(bids_join, [tab1, tab2], tab3, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab3, sort_by=['bid'], job_io={"table_writer":{"max_key_weight":131072}})


if __name__ == '__main__':
    main()
