#!/usr/bin/python
# -*- coding: utf-8 -*-

#добавление диапазонов номеров в таблицу смысловых структур

import sys
import re
import yt.wrapper as yt


def index_join(key, recs):
    row_index = -1
    number = 0
    size = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            row_index = rec['row_index']
            number = rec['number']
            size = rec['size']
        else:
            rec['last_index'] = number
            rec['size'] = size
            yield rec


def main():
    tab1 = '//home/catalogia/users/yuryz/etalon/block_num'
    tab2 = '//home/catalogia/users/yuryz/etalon/bnr_sense_num'
    tab3 = '//home/catalogia/users/yuryz/etalon/block_sens_num'

    yt.run_reduce(index_join, [tab1, tab2], tab3, reduce_by = ['row_index'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab3, sort_by=['row_index', 'last_index', 'size', 'sense', 'mctgs', 'bid'])

    print >> sys.stderr, yt.row_count(tab1)
    print >> sys.stderr, yt.row_count(tab2)
    print >> sys.stderr, yt.row_count(tab3)


if __name__ == '__main__':
    main()
