#!/usr/bin/python
# -*- coding: utf-8 -*-

#выбор эталонных баннеров на основе индивидуальных пороговых значений размеров блоков для каждой категории

import sys
import re
import yt.wrapper as yt

class sel_etalon(object): #выбор эталонных баннеров
    def __init__(self, thold_dic):
        self.thold_dic = thold_dic #словарь пороговых значений

    def __call__(self, rec):
        if rec['mctgs'] in self.thold_dic and rec['size'] >= int(self.thold_dic[rec['mctgs']][5]) and rec['size'] >= 1000:
            yield rec


def main():
    f = open('sem_groups_range', 'r')
    thold_dic = {} #пороговые значения

    while True:
        line = f.readline()
        if len(line) == 0: break

        line = line.rstrip('\n') #заголовок
        ctg, bnrs_total = line.split('\t')
        thold_dic[ctg] = {}
        for i in range(20): #% и пороговые значения
            line = f.readline()
            line = line.rstrip('\n')
            stub, percent, thold, bnrs_count = line.split('\t')
            thold_dic[ctg][int(percent)] = thold #вложенный словарь

    tab1 = '//home/catalogia/users/yuryz/etalon/block_sens_num'
    tab2 = '//tmp/yuryz/bnrs_etalon'

    yt.run_map(sel_etalon(thold_dic), tab1, tab2)
    yt.run_sort(tab2, sort_by=['bid', 'mctgs'])

    print yt.row_count(tab1)
    print yt.row_count(tab2)


if __name__ == '__main__':
    main()
