#!/usr/bin/python
# -*- coding: utf-8 -*-

#выбор баннеров для эталона

import sys
import re
import yt.wrapper as yt


DIST_MAX = 2 #максимальное расстояние для эталона (MAX расстояние = 15.68)
CLAST_MIN = 50 #минимальный размер кластера для эталона

def bnr_sel(rec):
    if rec['dist'] <= DIST_MAX and rec['clast_size'] <= -CLAST_MIN:
        if not re.findall('/', rec['mctgs']): #омонимы пока не обрабатываем
            yield { "bid": rec['bid'], "title": rec['title'], "body": rec['body'], "mctgs": rec['mctgs'], "domain": rec['domain'], "title_norm": rec['title_norm'], "body_norm": rec['body_norm'], "clast_phrase": rec['clast_phrase'] }
            yield { "mctgs": rec['mctgs'], "@table_index": 1 }


CTG_MIN = 30 #минимальное число баннеров в категории

def ctg_list(key, recs):
    num = 0
    for rec in recs:
        num += 1
    if num >= CTG_MIN:
        yield { "mctgs": key['mctgs'], "num": -num }


def bnrs_select(key, recs): #окончательный выбор эталонных баннеров
    ctg = ''
    num = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            ctg = rec['mctgs']
            num = rec['num']
        elif ctg != '': #оставляем только категории с числом баннеров >= CTG_MIN
            rec['num'] = num
            yield rec


def main():
    tab1 = '//home/catalogia/users/yuryz/ctg_corr/core_title_dist_size' #../ctg_corr/core_title_dist.py и ../ctg_corr/add_clast_size.py
    tab2 = '//tmp/yuryz/etalon_draft'
    tab3 = '//tmp/yuryz/ctg_count'

    yt.run_map(bnr_sel, tab1, [tab2, tab3], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab2, sort_by=['mctgs'])
    yt.run_sort(tab3, sort_by=['mctgs'])

    tab4 = '//home/catalogia/users/yuryz/contest/ctg_count'

    yt.run_reduce(ctg_list, tab3, tab4, reduce_by = ['mctgs'])
    yt.run_sort(tab4, sort_by=['mctgs'])

    tab5 = '//home/catalogia/users/yuryz/contest/etalon'

    yt.run_reduce(bnrs_select, [tab4, tab2], tab5, reduce_by = ['mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab5, sort_by=['bid'])

    print >> sys.stderr, DIST_MAX, CLAST_MIN, CTG_MIN, yt.row_count(tab4), yt.row_count(tab5)


if __name__ == '__main__':
    main()
