#!/usr/bin/python
# -*- coding: utf-8 -*-

#формирование ПОЛНОГО варианта обучающей выборки на основе заданного списка категорий

import sys
import re
import yt.wrapper as yt


def del_dup(key, recs): #удаление дублей
    yield recs.next()


def select(key, recs): #выбор полных вариантов обучающих выборок
    mctgs = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            mctgs = rec['mctgs']
        elif mctgs != '':
            yield { "bid": rec['bid'], "title": rec['title'], "body": rec['body'], "mctgs": rec['mctgs'], "domain": rec['domain'] }


def convert(key, recs): #преобразование форматов таблиц
    bid = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            rec2 = rec
            bid = rec2['bid']
        elif bid != 0:
            if rec['href'] and rec['href'] != '' and len(rec['href']) >= 5:
                yield { "bid": rec2['bid'], "title": rec2['title'], "body": rec2['body'], "mctgs": rec2['mctgs'], "domain": rec2['domain'], "href": rec['href'], "phrases": rec['phrases'], "title_extension": rec['title_extension'] }


def main():
    #--- 1. Удаление дублей title_norm + body_norm (с учетом порядка) ---
    tab1 = '//home/catalogia/users/yuryz/ctg_corr/core_title_dist_size'
    tab2 = '//tmp/yuryz/tmp'
    tab3 = '//tmp/yuryz/core_title_dist_size_uniq'

    #yt.run_sort(tab1, tab2, sort_by=['title_norm', 'body_norm', 'bid'])
    #yt.run_reduce(del_dup, tab2, tab3, reduce_by = ['title_norm', 'body_norm'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab3, sort_by=['mctgs', 'clast_size', 'clast_phrase', 'dist', 'bid'])

    #--- 2. Выбор данных из заданного списка категорий ---
    tab4 = '//home/catalogia/users/yuryz/contest/ctg_count'
    tab5 = '//tmp/yuryz/cts_train_full'

    #yt.run_reduce(select, [tab4, tab3], tab5, reduce_by = ['mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab5, sort_by=['bid'])

    #--- 3. Добавление полей из banners_extended ---
    tab6 = '//home/catalogia/banners_extended'
    tab7 = '//tmp/yuryz/cts_train_full_2'
    tab8 = '//home/catalogia/users/yuryz/contest/bnrs4contest'

    #yt.run_reduce(convert, [tab5, tab6], tab7, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab7, tab8, sort_by=['bid'])

    print >> sys.stderr, yt.row_count(tab1)
    print >> sys.stderr, yt.row_count(tab2)
    print >> sys.stderr, yt.row_count(tab3)

    print >> sys.stderr, yt.row_count(tab4)
    print >> sys.stderr, yt.row_count(tab5)

    print >> sys.stderr, yt.row_count(tab6)
    print >> sys.stderr, yt.row_count(tab7)
    print >> sys.stderr, yt.row_count(tab8)


if __name__ == '__main__':
    main()
