#!/usr/bin/python
# -*- coding: utf-8 -*-

#формирование ПОЛНОГО варианта обучающей выборки на основе заданного списка категорий (с результатами нормализации)

import sys
import re
import yt.wrapper as yt


def del_dup(key, recs): #удаление дублей
    yield recs.next()


def select(key, recs): #выбор полных вариантов обучающих выборок
    mctgs = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            mctgs = rec['mctgs']
        elif mctgs != '':
            yield { "bid": rec['bid'], "title": rec['title'], "body": rec['body'], "mctgs": rec['mctgs'], "domain": rec['domain'], "title_norm": rec['title_norm'], "body_norm": rec['body_norm'], "clast_phrase": rec['clast_phrase'] }


def main():
    #--- ВАРИАНТ с удалением дублей title_norm + body_norm (с учетом порядка) ---
    tab1 = '//home/catalogia/users/yuryz/ctg_corr/core_title_dist_size'
    tab2 = '//tmp/yuryz/tmp'
    tab3 = '//tmp/yuryz/core_title_dist_size'

    #yt.run_sort(tab1, tab2, sort_by=['title_norm', 'body_norm', 'bid'])
    #yt.run_reduce(del_dup, tab2, tab3, reduce_by = ['title_norm', 'body_norm'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab3, sort_by=['mctgs', 'clast_size', 'clast_phrase', 'dist', 'bid'])
    #--- ВАРИАНТ с удалением дублей title_norm + body_norm (с учетом порядка) ---

    #tab1 = '//home/catalogia/users/yuryz/ctg_corr/core_title_dist_size'
    tab1 = tab3

    tab2 = '//home/catalogia/users/yuryz/contest/ctg_count'
    tab3 = '//home/catalogia/users/yuryz/contest/train_full'

    yt.run_reduce(select, [tab2, tab1], tab3, reduce_by = ['mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab3, sort_by=['bid'])

    print >> sys.stderr, yt.row_count(tab1)
    print >> sys.stderr, yt.row_count(tab2)
    print >> sys.stderr, yt.row_count(tab3)


if __name__ == '__main__':
    main()
