#!/usr/bin/python
# -*- coding: utf-8 -*-

#формирование ПОЛНОГО варианта обучающей выборки на основе заданного списка категорий (с результатами нормализации)

import sys
import re
import yt.wrapper as yt


def select(key, recs): #выбор полных вариантов обучающих выборок
    mctgs = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            mctgs = rec['mctgs']
        elif mctgs != '':
            yield rec


def main():
    tab0 = '//home/catalogia/users/yuryz/bnrs_norm'
    tab1 = '//tmp/yuryz/bnrs_norm'

    yt.run_sort(tab0, tab1, sort_by=['mctgs', 'bid'])

    tab2 = '//home/catalogia/users/yuryz/contest/ctg_count'
    tab3 = '//home/catalogia/users/yuryz/contest/train_full_800'

    yt.run_reduce(select, [tab2, tab1], tab3, reduce_by = ['mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab3, sort_by=['bid'])

    print >> sys.stderr, yt.row_count(tab1)
    print >> sys.stderr, yt.row_count(tab2)
    print >> sys.stderr, yt.row_count(tab3)


if __name__ == '__main__':
    main()
