#!/usr/bin/python
# -*- coding: utf-8 -*-

#формирование ПОЛНОГО варианта обучающей выборки на основе заданного списка категорий

import sys
import re
import yt.wrapper as yt


def select(key, recs): #выбор полных вариантов обучающих выборок
    mctgs = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            mctgs = rec['mctgs']
        elif mctgs != '':
            yield { "bid": rec['bid'], "title": rec['title'], "body": rec['body'], "mctgs": rec['mctgs'], "domain": rec['domain'], "title_norm": rec['title_norm'], "body_norm": rec['body_norm'], "clast_phrase": rec['clast_phrase'] }


def convert(key, recs): #преобразование форматов таблиц
    bid = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            rec2 = rec
            bid = rec2['bid']
        elif bid != 0:
            phrases = ''
            if rec['phrases'] and rec['phrases'] != '':
                phrs = rec['phrases'].split(',') #фразы
                uniq = {}
                for phr in phrs:
                    words = phr.split(' ') #слова фразы
                    for word in words:
                        if re.search(r'^\-', word): #минус-слова
                            continue
                        word = re.sub(r'~0$', '', word)
                        word = re.sub(r':.+$', '', word) #статистика
                        #word = re.sub(r'^\+', '', word)
                        if word not in uniq:
                            uniq[word] = 1

                L = uniq.keys()
                L.sort()
                phrases = ' '.join(L) #уникальные слова всех фраз

            yield { "bid": rec2['bid'], "title": rec2['title'], "body": rec2['body'], "mctgs": rec2['mctgs'], "domain": rec2['domain'], "title_norm": rec2['title_norm'], "body_norm": rec2['body_norm'], "clast_phrase": rec2['clast_phrase'], "href": rec['href'], "phrases": phrases, "title_extension": rec['title_extension'] }


def main():
    #--- 1. Выбор данных из заданного списка категорий ---
    tab1 = '//home/catalogia/users/yuryz/ctg_corr/core_title_dist_size'
    tab2 = '//home/catalogia/users/yuryz/contest/ctg_count'
    tab3 = '//tmp/yuryz/train_full'

    yt.run_reduce(select, [tab2, tab1], tab3, reduce_by = ['mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab3, sort_by=['bid'])

    #--- 2. Добавление полей из banners_extended ---
    tab4 = '//home/catalogia/banners_extended'
    tab5 = '//home/catalogia/users/yuryz/contest/train_full_phr'

    yt.run_reduce(convert, [tab3, tab4], tab5, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab5, sort_by=['bid'])

    print >> sys.stderr, yt.row_count(tab1)
    print >> sys.stderr, yt.row_count(tab2)
    print >> sys.stderr, yt.row_count(tab3)

    print >> sys.stderr, yt.row_count(tab4)
    print >> sys.stderr, yt.row_count(tab5)


if __name__ == '__main__':
    main()
