#!/usr/bin/python
# -*- coding: utf-8 -*-

#оценка семантической близости для ближайших соседей виртуальной категории по дереву Каталогии

import sys
import re
import yt.wrapper as yt


def neighbor_near(key, recs):
    ctgs = [] #ближайшие соседи по дереву

    ctgs_rank = {} #семантические ранги соседей по дереву
    num = 0 #номер соседа по дереву в семантическом списке
    neighbor_tree = "NOT FOUND"
    neighbor_tree_num = 50000
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            ctgs.append(rec['ctg2'])
        elif len(ctgs) > 0:
            num += 1
            if num == 1: neighbor_semantic = rec['ctg2'] #ближайший семантический сосед (может совпасть с ближайшим сосоедом по дереву)
            if rec['ctg2'] in ctgs:
                neighbor_tree = rec['ctg2']
                neighbor_tree_num = num
                ctgs_rank[rec['ctg2']] = num
                break

    if num > 0:
        ctgs.sort()
        ctgs_rel = '\t'.join(ctgs) #исходные родственные категории
        yield { "ctg_virt": key['ctg1'], "neighbor_tree": neighbor_tree, "neighbor_tree_num": neighbor_tree_num, "categs_relativ": ctgs_rel, "neighbor_semantic": neighbor_semantic }


def main():
    tab1 = '//tmp/yuryz/ctgs_pair'
    tab2 = '//home/catalogia/users/yuryz/compare/ctg_proxim'
    tab3 = '//home/catalogia/users/yuryz/compare/neighbor_near'

    yt.run_reduce(neighbor_near, [tab1, tab2], tab3, reduce_by = ['ctg1'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab3, sort_by=['neighbor_tree_num', 'ctg_virt', 'neighbor_tree', 'neighbor_semantic'])

    #for rec in yt.read_table(tab3, raw=False):
    #    ctgs_rel = rec['categs_relativ'].split('\t')
    #    print rec['ctg_virt'] + '\t' + rec['neighbor_tree'] + '\t' + str(rec['neighbor_tree_num']) + '\t' + rec['neighbor_semantic'] + '\t' + '*'.join(ctgs_rel)

    print >> sys.stderr, yt.row_count(tab3)

if __name__ == '__main__':
    main()
