#!/usr/bin/python
# -*- coding: utf-8 -*-

#выбор эталонных баннеров для тестирования

import sys
import re
import random
import yt.wrapper as yt


class bnr_sel(object):
    def __init__(self, thresh):
        self.thresh = thresh

    def __call__(self, rec):
        if random.random() <= self.thresh:
            yield rec


def main():
    tab1 = '//home/catalogia/users/yuryz/ctg_corr/etalon'
    tab2 = '//home/catalogia/users/yuryz/ctg_corr/sample'

    ETALON_SIZE = yt.row_count(tab1) #размер эталонной выборки
    SET_SIZE = 250 #размер сета для проверки
    THRESH = float(SET_SIZE) / ETALON_SIZE

    yt.run_map(bnr_sel(THRESH), tab1, tab2)
    yt.run_sort(tab2, sort_by=['bid'])

    print >> sys.stderr, yt.row_count(tab1)
    print >> sys.stderr, yt.row_count(tab2)

    print 'bid\ttitle\tbody\touter_category'
    for rec in yt.read_table(tab2, raw=False):
        print str(rec['bid']) + '\t' + rec['title']+ '\t' + rec['body'] + '\t' + rec['mctgs']


if __name__ == '__main__':
    main()
