#!/usr/bin/python
# -*- coding: utf-8 -*-

#формирование исходного списка тем с размерами внутри категорий

import os.path
import sys
import re
import yt.wrapper as yt


def fields_sel(rec): #конвертирование основной таблицы ядер к формату, удобному для сравнения
    yield { "ctg": rec['mctgs'], "topic": rec['two_word_index'], "clust_size": -rec['clast_size'] } #категория, тема, размер кластера


def topic_size(key, recs): #размеры тем
    if re.search(r' _ ', key['ctg']): return #виртуалки не учитываем

    topics = {}
    total = 0; #общее число баннеров в категории
    for rec in recs:
        if rec['topic'] in topics:
            topics[rec['topic']] += rec['clust_size']
        else:
            topics[rec['topic']] = rec['clust_size']
        total += rec['clust_size']

    for topic in topics:
        yield { "ctg": rec['ctg'], "topic": topic, "topic_size": topics[topic], "total_size": total }


def main():
    tab1 = '//home/catalogia/users/yuryz/tmp/sem_core_clast_size' #таблица семантических ядер
    tab2 = '//home/catalogia/users/yuryz/hier_clust/sem_cores'

    #yt.run_map(fields_sel, tab1, tab2, format=yt.YsonFormat(control_attributes_mode="row_fields")) #конвертирование
    #yt.run_sort(tab2, sort_by=['ctg', 'topic', 'clust_size'])

    tab3 = '//home/catalogia/users/yuryz/hier_clust/topic_size' #темы с размерами внутри категорий

    yt.run_reduce(topic_size, tab2, tab3, reduce_by = ['ctg'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab3, sort_by=['topic', 'ctg'])


if __name__ == '__main__':
    main()
