#!/usr/bin/python
# -*- coding: utf-8 -*-

#определение пар категорий с максимальной близостью и формирование списков категорий с номерами кластеров

import os.path
import sys
import re
import yt.wrapper as yt


def ctgs_cross(key, recs): #пересечение категорий
    ctgs = list(recs)
    if len(ctgs) == 1: return
    for i in range(len(ctgs)-1):
        weightI = float(ctgs[i]['topic_size']) / ctgs[i]['total_size']
        for j in range(i+1, len(ctgs)):
            weightJ = float(ctgs[j]['topic_size']) / ctgs[j]['total_size']
            min_weight = min(weightI, weightJ)
            yield { "ctg1": ctgs[i]['ctg'], "ctg2": ctgs[j]['ctg'], "topic": key['topic'], "weight": min_weight }
            yield { "ctg1": ctgs[j]['ctg'], "ctg2": ctgs[i]['ctg'], "topic": key['topic'], "weight": min_weight }


def ctgs_proxim(key, recs): #близость категорий
    proxim = 0;
    for rec in recs:
        proxim += rec['weight']
    yield { "ctg1": key['ctg1'], "ctg2": key['ctg2'], "proxim": -proxim }


def ctg_nearest(key, recs): #выбор ближайшей категории
    yield recs.next()


def main():
    tab1 = '//home/catalogia/users/yuryz/hier_clust/topic_size' #темы с размерами внутри категорий (python hier_clust1.py)
    tab2 = '//home/catalogia/users/yuryz/hier_clust/ctg_cross' #пересечение пар категорий по темам

    yt.run_reduce(ctgs_cross, tab1, tab2, reduce_by = ['topic'], spec = {'job_count': 1000}, format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab2, sort_by=['ctg1', 'ctg2', 'topic'], spec = {'job_count': 1000})

    tab3 = '//home/catalogia/users/yuryz/hier_clust/ctg_proxim' #близость категорий

    yt.run_reduce(ctgs_proxim, tab2, tab3, reduce_by = ['ctg1', 'ctg2'], spec = {'job_count': 1000}, format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab3, sort_by=['ctg1', 'proxim', 'ctg2'])

    tab4 = '//home/catalogia/users/yuryz/hier_clust/ctg_nearest' #ближайшая категория

    yt.run_reduce(ctg_nearest, tab3, tab4, reduce_by = ['ctg1'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab4, sort_by=['proxim', 'ctg1'])

    #---формирование очередного списка кластеров ---
    if not os.path.exists("clust_num_max"): #номер последнего созданного кластера
        f = open("clust_num_max", "w")
        f.write("0")
        f.close()
    f = open("clust_num_max", "r")
    clust_num_max = int(f.read())
    f.close()

    clusters = {} #отображение категории в кластер

    proxim_prev = 0
    for rec in yt.read_table(tab4, raw=False):
        if proxim_prev == 0: proxim_prev = rec['proxim'] #максимальное сходство
        #if rec['proxim'] == proxim_prev: #кластеры создаются только для пар категорий с максимальным сходством
        if float(rec['proxim']) / proxim_prev >= 0.9: #кластеры создаются только для пар категорий с максимальным сходством
            if rec['ctg1'] in clusters:
                clusters[rec['ctg2']] = clusters[rec['ctg1']]
            elif rec['ctg2'] in clusters:
                clusters[rec['ctg1']] = clusters[rec['ctg2']]
            else:
                clust_num_max += 1 #текущий номер кластера
                clusters[rec['ctg1']] = clust_num_max
                clusters[rec['ctg2']] = clust_num_max

    f = open("clust_num_max", "w")
    f.write(str(clust_num_max))
    f.close()

    for ctg, clust_num in clusters.items():
        print ctg + '\t' + str(clust_num)


if __name__ == '__main__':
    main()
