#!/usr/bin/python
# -*- coding: utf-8 -*-

#объединение тем для очередного цикла определения близости категорий

import os.path
import sys
import re
import yt.wrapper as yt


class topic_union(object): #объединение тем
    def __init__(self, clusters):
        self.clusters = clusters #категории с указанием номера кластера

    def __call__(self, key, recs):
        topic_size = {}
        total_size = {}
        for rec in recs:
            if rec['ctg'] in self.clusters:
                ctg = self.clusters[rec['ctg']]
                if ctg in topic_size:
                    topic_size[ctg] += rec['topic_size']
                    total_size[ctg] += rec['total_size']
                else:
                    topic_size[ctg] = rec['topic_size']
                    total_size[ctg] = rec['total_size']
            else:
                yield rec

        for ctg in topic_size:
            yield { "topic": key['topic'], "ctg": 'C' + str(ctg), "topic_size": topic_size[ctg], "total_size": total_size[ctg] }


def main():
    clusters = {}
    f = open('clust_with_num', 'r') #категории с указанием номера кластера (bash hier_clust.sh (python hier_clust2.py))
    for line in f:
        line = line.rstrip('\n')
        ctg, clust_num = line.split('\t')
        clusters[ctg] = clust_num

    #for ctg, clust_num in clusters.items():
    #    print ctg + '\t' + str(clust_num)

    tab1 = '//home/catalogia/users/yuryz/hier_clust/topic_size' #темы с размерами внутри категорий (python hier_clust1.py)
    tab2 = '//tmp/yuryz/topic_size' #результат объединения тем

    yt.run_reduce(topic_union(clusters), tab1, tab2, reduce_by = ['topic'], spec = {'job_count': 1000}, format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab2, sort_by=['topic', 'ctg'], spec = {'job_count': 1000})

    if yt.exists(tab1):
        yt.remove(tab1)
    yt.copy(tab2, tab1)


if __name__ == '__main__':
    main()
