#!/usr/bin/perl -w
#выбор поля CategoryNames по аналогии

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


my %lemm;
open F, "hint_dict_lemm"; #см. hint_dict_lemm.pl
#AutoCategoryNames CategoryNames lemms
while (<F>) {
    chomp;
    my ($AutoCategoryNames, $CategoryNames, $lemms) = split /\t/;
    $lemm{$AutoCategoryNames}{$CategoryNames} = $lemms;
}
close F;

my %ctgs; #катеории Каталогии
open F, "hint_Unit_dsm_zip"; #hint_Unit_dsm_zip.pl
while (<F>) {
    chomp;
    my ($AutoCategoryNames, $CategoryNames, $BannerID, $Title, $Body, $Domain) = split /\t/;
    next if $AutoCategoryNames =~ /^AutoCategoryNames/; #заголовок

    my %dup = ();
    my @uniq = grep { !$dup{$_}++ } split m{/}, $AutoCategoryNames; #удаление дублей
    $AutoCategoryNames = join("/", sort(@uniq));

    %dup = ();
    @uniq = grep { !$dup{$_}++ } split m{/}, $CategoryNames; #удаление дублей
    $CategoryNames = join("/", sort(@uniq));

    $ctgs{$AutoCategoryNames}{$CategoryNames}++ if $BannerID !~ /^\[/; #TestExact (вместо $CoreCategoryNames здесь BannerID)
}
close F;

open F, "hint_Unit_dsm_zip"; #hint_Unit_dsm_zip.pl
#AutoCategoryNames CategoryNames [CoreCategoryNames] BannerID Title Body Domain
while (<F>) {
    chomp;
    my ($AutoCategoryNames, $CategoryNames, $CoreCategoryNames, $BannerID, $Title, $Body, $Domain) = split /\t/;
    next if $AutoCategoryNames =~ /^AutoCategoryNames/; #заголовок

    if ($CoreCategoryNames =~ /^\[/) { #Test
        $CoreCategoryNames =~ s/^\[//;
        $CoreCategoryNames =~ s/\]$//;

        my %dup = ();
        my @uniq = grep { !$dup{$_}++ } split m{/}, $CoreCategoryNames; #удаление дублей

        $CoreCategoryNames = join("/", sort(@uniq));

        ##################################################
        my $title_pre = $proj->phrase($Title)->get_banner_prefiltered_phrase->text; #префильтрация title
        my $title_nrm = $proj->phrase($title_pre)->norm_phr_ordered; #нормализация title с учетом порядка слов

        my $body_pre = $proj->phrase($Body)->get_banner_prefiltered_phrase->text; #префильтрация body
        my $body_nrm = $proj->phrase($body_pre)->norm_phr_ordered; #нормализация body с учетом порядка слов

        %dup = ();
        @uniq = grep { !$dup{$_}++ } split / /, "$title_nrm $body_nrm"; #удаление дублей из нормализованного текста

        my @uniq_clean; #слова из @uniq, очищенные от посторонних знаков
        for my $uniq (@uniq) {
            $uniq =~ s/^[!+\$]+//; #см. tf_idf_1.py
            next if length($uniq) <= 1 || $uniq =~ /^([0-9.]+|самовывоз|сегодня|всегда|каждый|минута|нечего|оплата|сейчас|более|здесь|любой|много|стать|также|есть|жать|ваш|где|мес|мин|раз|руб|тут|тыс|час|др|кв|кг|км|м2|мм|пр|см|ул)$/ || $uniq =~ /^_/ || $uniq eq "moderatebadwordtype"; #см. tf_idf_1.py
            push @uniq_clean, $uniq;
        }
        @uniq_clean = sort(@uniq_clean);

        my $lemms = join(" ", @uniq_clean);
        ##################################################

        if ($CoreCategoryNames =~ /(Скидочные купоны)/) {
            $CoreCategoryNames = $AutoCategoryNames;
        } elsif (is_ancestor($CoreCategoryNames, $AutoCategoryNames)) { ###
        } elsif (!$ctgs{$AutoCategoryNames}) { #нет аналогичных образцов
            $CoreCategoryNames = ctg_best($AutoCategoryNames, $CoreCategoryNames); #выбор лучшего варианта категории при омонимии
        } else {
            my @keys = sort { $ctgs{$AutoCategoryNames}{$b} <=> $ctgs{$AutoCategoryNames}{$a} } keys %{$ctgs{$AutoCategoryNames}};
            if (@keys == 1) {
                if ($ctgs{$AutoCategoryNames}{$keys[0]} > 1) { #вхождения $CoreCategoryNames в $CategoryNames из TestExact отсутствуют
                    $CoreCategoryNames = $keys[0] if $CoreCategoryNames ne $AutoCategoryNames; #$CategoryNames из TestExact
                } else { ###
                    $CoreCategoryNames = ctg_best($AutoCategoryNames, $CoreCategoryNames); #выбор лучшего варианта категории при омонимии
                }
            } else { #@keys > 1
                my $i_max = -1;
                my $cross_max = -1;
                for my $i (0..$#keys) {
                    if ($lemm{$AutoCategoryNames}{$keys[$i]}) {
                        my $cross = cross($lemms, $lemm{$AutoCategoryNames}{$keys[$i]});
                        if ($cross_max < $cross) {
                            $cross_max = $cross;
                            $i_max = $i;
                        }
                    }
                }

                if ($cross_max > 3) { #8466
                    $CoreCategoryNames = $keys[$i_max] if $CoreCategoryNames ne $AutoCategoryNames;
                } else {
                    my $diff = $ctgs{$AutoCategoryNames}{$keys[0]} - $ctgs{$AutoCategoryNames}{$keys[1]};
                    if ($diff > 4) { #вхождения $CoreCategoryNames в $CategoryNames из TestExact отсутствуют
                        $CoreCategoryNames = $keys[0] if $CoreCategoryNames ne $AutoCategoryNames; #$CategoryNames из TestExact
                    } elsif ($diff > 3) {
                        if ($lemm{$AutoCategoryNames}{$keys[0]}) {
                            my $cross = cross($lemms, $lemm{$AutoCategoryNames}{$keys[0]});
                            $CoreCategoryNames = $keys[0] if $cross > 0 && $CoreCategoryNames ne $AutoCategoryNames;
                        } else {
                            $CoreCategoryNames = ctg_best($AutoCategoryNames, $CoreCategoryNames); #выбор лучшего варианта категории при омонимии
                        }
                    } else {
                        $CoreCategoryNames = ctg_best($AutoCategoryNames, $CoreCategoryNames); #выбор лучшего варианта категории при омонимии
                    }
                }
            }
        }

        print "$BannerID\t$Title\t$Body\t$Domain\t$CoreCategoryNames\t$CategoryNames\n";
    }
}
close F;


#--- пересечение массивов ---
sub cross {
    my ($a, $b) = @_;

    my @a = split / /, $a;
    my %cross;
    $cross{$_} = 1 for @a;

    my $cross = 0;
    my @b = split / /, $b;
    for (@b) {
        $cross++ if $cross{$_};
    }

    return $cross;
}


#--- выбор лучшей из нескольких категорий $CoreCategoryNames ---
sub ctg_best {
    my ($AutoCategoryNames, $CoreCategoryNames) = @_;

    my @a = split m{/}, $CoreCategoryNames;
    if (@a > 1) {
        my $sim_max = -1;
        my $i_max = -1;
        for my $i (0..$#a) {
            my $sim = ctgs_sim($AutoCategoryNames, $a[$i]);
            if ($sim > $sim_max) {
                $sim_max = $sim;
                $i_max = $i;
            }
        }
        $CoreCategoryNames = $a[$i_max];
    }

    return $CoreCategoryNames;
}


#--- вычисление сходства между мультимножествами автокатегории и категорией ядра ---
sub ctgs_sim {
    my ($AutoCategoryNames, $CoreCategoryNames) = @_;

    my $AutoMS = mset($AutoCategoryNames); #мультимножество автокатегории
    my ($countI, @pairsI) = split /\t/, $AutoMS;
    my %dicI; #мультимножество (частотный словарь)
    for (my $i2 = 0; $i2 <= $#pairsI-1; $i2 += 2) { #
        $dicI{$pairsI[$i2]} = $pairsI[$i2+1]
    }

    my $CoreMS = mset($CoreCategoryNames); #мультимножество категории ядра
    my ($countJ, @pairsJ) = split /\t/, $CoreMS;
    my $cross = 0; #пересечение множеств
    for (my $j2 = 0; $j2 <= $#pairsJ-1; $j2 += 2) { #
        if ($dicI{$pairsJ[$j2]}) {
            $cross += $dicI{$pairsJ[$j2]} <= $pairsJ[$j2+1] ? $dicI{$pairsJ[$j2]} : $pairsJ[$j2+1]; #min частота
        }
    }

    my $sim = sprintf("%.3f", 2.0 * $cross / ($countI + $countJ));

    return $sim;
}


#--- вычисление мультимножества ---
sub mset {
    my ($mctgs) = @_;

    my @ctgs = split m{/}, $mctgs;
    my $cnt = 0; #количество элементов мультимножества
    my %dic = (); #частотный словарь категорий (мультимножество)

    for my $ctgs (@ctgs) {
        my $anc = ancestors_add($ctgs); #предки категории
        my @anc = split m{/}, $anc;
        for (@anc) {
            $cnt++;
            $dic{$_}++;
        }
    }

    my @pairs = ();
    for (sort keys %dic) {
        push @pairs, "$_\t$dic{$_}"; #пары <категория, частота>
    }

    return "$cnt\t".join("\t", @pairs); #мультимножество
}


#--- добавление предков для категории ---
sub ancestors_add {
    my ($categ) = @_;

    my @ancestors; #все предки категории
    my $ancestor = $categ;
    while ($ancestor = $proj->categs_tree->get_minicateg_parent($ancestor)) {
        push @ancestors, $ancestor;
    }

    return join("/", reverse @ancestors)."/$categ";
}


#--- проверка, что вторая категория является предком первой ---
sub is_ancestor {
    my ($ctg1, $ctg2) = @_;

    my %ctg2;
    my @ctg2 = split m{/}, $ctg2;
    $ctg2{$_} = 1 for @ctg2;

    my @ctg1 = split m{/}, $ctg1;
    return 0 if @ctg1 > 1;
    my $anc = $proj->categs_tree->get_minicateg_parent($ctg1); #предок
    return $anc && $ctg2{$anc} ? 1 : 0;
}
