#!/usr/bin/perl -w
#выбор поля CategoryNames по аналогии

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});

my %ctgs;
my %lemm;
open F, "hint_Unit_dsm";
#AutoCategoryNames CategoryNames BannerID Title Body Domain
while (<F>) {
    chomp;
    my ($AutoCategoryNames, $CategoryNames, $BannerID, $Title, $Body, $Domain) = split /\t/;
    next if $AutoCategoryNames =~ /^AutoCategoryNames/; #заголовок

    $AutoCategoryNames = join("/", sort(split m{/}, $AutoCategoryNames));
    $CategoryNames = join("/", sort(split m{/}, $CategoryNames));

    $ctgs{$AutoCategoryNames}{$CategoryNames}++ if $BannerID !~ /^\[/; #TestExact (вместо $CoreCategoryNames здесь BannerID)

    ##################################################
    if ($BannerID !~ /^\[/) { #TestExact (вместо $CoreCategoryNames здесь BannerID)
        my $title_pre = $proj->phrase($Title)->get_banner_prefiltered_phrase->text; #префильтрация title
        my $title_nrm = $proj->phrase($title_pre)->norm_phr_ordered; #нормализация title с учетом порядка слов

        my $body_pre = $proj->phrase($Body)->get_banner_prefiltered_phrase->text; #префильтрация body
        my $body_nrm = $proj->phrase($body_pre)->norm_phr_ordered; #нормализация body с учетом порядка слов

        my %dup;
        my @uniq = grep { !$dup{$_}++ } split / /, "$title_nrm $body_nrm"; #удаление дублей из нормализованного текста

        my @uniq_clean; #слова из @uniq, очищенные от посторонних знаков
        for my $uniq (@uniq) {
            $uniq =~ s/^[!+\$]+//; #см. tf_idf_1.py
            next if length($uniq) <= 1 || $uniq =~ /^([0-9.]+|самовывоз|сегодня|всегда|каждый|минута|нечего|оплата|сейчас|более|здесь|любой|много|стать|также|есть|жать|ваш|где|мес|мин|раз|руб|тут|тыс|час|др|кв|кг|км|м2|мм|пр|см|ул)$/ || $uniq =~ /^_/ || $uniq eq "moderatebadwordtype"; #см. tf_idf_1.py
            push @uniq_clean, $uniq;
        }
        @uniq_clean = sort(@uniq_clean);

        $lemm{$AutoCategoryNames}{$CategoryNames} = join(" ", @uniq_clean);
    }
    ##################################################

}
close F;

for my $ctg_auto (sort keys %lemm) {
    for my $ctg_name (sort { $lemm{$ctg_auto}{$b} cmp  $lemm{$ctg_auto}{$a} } keys %{$lemm{$ctg_auto}}) {
        print "$ctg_auto\t$ctg_name\t", $lemm{$ctg_auto}{$ctg_name}, "\n";
    }
}
