#!/usr/bin/python
# -*- coding: utf-8 -*-

#первичный выбор баннеров из BANNERS_EXTENDED с учетом Ксюшиной разметки

import sys
import re
import yt.wrapper as yt

from urlparse import urlparse

class bnrs_select(object): #выбор баннеров
    def __init__(self, bnr_type, ksu_mctgs, ksu_bids_private, ksu_bids_public):
        self.bnr_type = bnr_type #1 - обычные баннеры, 2 - омонимичные баннеры, 3 - те и другие
        self.ksu_mctgs = ksu_mctgs #словарь категорий из Ксюшиной разметки
        self.ksu_bids_private = ksu_bids_private #баннеры, входящие в //home/catalogia/contest/Test
        self.ksu_bids_public = ksu_bids_public #баннеры, входящие в //home/catalogia/contest/TrainExact

    def __call__(self, rec):
        if rec['mctgs'] and rec['mctgs'] != '' and rec['title'] and rec['title'] != '' and rec['body'] and rec['body'] != '':
            slash = rec['mctgs'].find('/')
            if self.bnr_type == 1 and slash == -1 or self.bnr_type == 2 and slash > 0 or self.bnr_type == 3:
                phrases = ''
                if rec['phrases'] and rec['phrases'] != '':
                    phrs = rec['phrases'].split(',') #фразы
                    uniq = {}
                    for phr in phrs:
                        words = phr.split(' ') #слова фразы
                        for word in words:
                            if re.search(r'^\-', word): #минус-слова
                                continue
                            word = re.sub(r'~0$', '', word)
                            word = re.sub(r':.+$', '', word) #статистика
                            #word = re.sub(r'^\+', '', word)
                            if word not in uniq:
                                uniq[word] = 1

                    L = uniq.keys()
                    L.sort()
                    phrases = ' '.join(L) #уникальные слова всех фраз

                ##if str(rec['bid']) not in self.ksu_bids_private:
                if True:
                    ctgs = ''
                    if str(rec['bid']) in self.ksu_bids_public:
                    ##if False:
                        ctgs = self.ksu_bids_public[str(rec['bid'])].split('/')
                    else:
                        ctgs = rec['mctgs'].split('/')
                    for ctg in ctgs:
                        if ctg in self.ksu_mctgs:
                            yield { "bid": rec['bid'], "title": rec['title'], "body": rec['body'], "mctgs": ctg, "domain": rec['domain'], "phrases": phrases, "title_extension": rec['title_extension'] }


def del_dup(key, recs): #удаление полных дублей
    yield recs.next()


def main():
    tab1 = sys.argv[2] #'//home/catalogia/banners_extended'
    tab2 = '//tmp/yuryz/bnrs_select' #выбранные баннеры

    ksu_mctgs = {} #отбираем только баннеры с категориями из Ксюшиной разметки (для сокращения числа ядер)
    f = open('ksu_mctgs', 'r')
    for line in f:
        mctgs = line.rstrip('\n')
        ksu_mctgs[mctgs] = 1

    ksu_bids_private = {} #исключаем баннеры, входящие в //home/catalogia/contest/Test
    f = open('ksu_bids_private', 'r')
    for line in f:
        bid = line.rstrip('\n')
        ksu_bids_private[bid] = 1

    ksu_bids_public = {} #заменяем категории у баннеров, входящих в //home/catalogia/contest/TrainExact
    #f = open('ksu_bids_public', 'r')
    f = open('ksu_bids_public_ext', 'r')
    for line in f:
        bnr = line.rstrip('\n')
        mctgs, bid = bnr.split('\t')
        ksu_bids_public[bid] = mctgs

    yt.run_map(bnrs_select(int(sys.argv[1]), ksu_mctgs, ksu_bids_private, ksu_bids_public), tab1, tab2) # 1 - обычные баннеры, 2 - омонимичные баннеры, 3 - те и другие
    yt.run_sort(tab2, sort_by=['title', 'body', 'mctgs', 'bid'])

    print yt.row_count(tab1)
    print yt.row_count(tab2)

    tab3 = sys.argv[3] #баннеры БЕЗ дублей

    yt.run_reduce(del_dup, tab2, tab3, reduce_by=['title', 'body', 'mctgs']) #без сортировки по bid, т.к. дальше идет обычный map (см. core_sense.sh)

    print yt.row_count(tab3)


if __name__ == '__main__':
    main()
