#!/usr/bin/python
# -*- coding: utf-8 -*-

#для баннеров, у которых вручную исправлены категории, выбор окрестностей из соответствующих кластеров, и замена категорий на исправленную вручную

import sys
import re
import yt.wrapper as yt

DIST_MAX = 1 #1.5, 0.7 максимально допустимое расстояние внутри окрестности
NEIGHBOR_MAX = 50 #1000000, 30 максимальное число ближайших соседей

def clast_select(key, recs): #выбор ошибочных баннеров из кластеров
    mctgs = ''
    clast_size = 0
    bnrs = [] #баннеров с корректировочной информацией, имеющих одинаковые ['mctgs', 'clast_phrase'] м.б. несколько

    for rec in recs:
        #формируем список уникальных значащих слов баннера
        bnorm = rec['title_norm'] + ' ' + rec['body_norm']
        wrds = bnorm.split()
        S = set(wrds) #удаляем дубли
        S = list(S)
        S.sort()
        T = []
        for wrd in S:
            wrd = re.sub('^[!+$]+', '', wrd)
            #через без для под про со с
            if len(unicode(wrd, 'utf-8')) <= 1 or re.findall('^([0-9.]+|самовывоз|сегодня|всегда|каждый|минута|нечего|оплата|сейчас|более|здесь|любой|много|стать|также|есть|жать|ваш|где|мес|мин|раз|руб|тут|тыс|час|др|кв|кг|км|м2|мм|пр|см|ул)$', wrd) or re.findall('^_', wrd) or wrd == 'moderatebadwordtype':
                continue
            T.append(wrd)
        bnorm = ' '.join(T) #уникальные значащие слова баннера

        table_index = rec.pop('@table_index')
        if table_index == 0: #баннер с КОРРЕКТИРОВОЧНОЙ информацией
            mctgs = rec['mctgs']
            rec['title_body_corr'] = bnorm #для вычисления биграммного сходства
            bnrs.append(rec)
        elif mctgs != '': #остальные баннеры ядра (ВАЖНО: включает баннер с КОРРЕКТИРОВОЧНОЙ информацией)
            title_body = bnorm #для биграммного вычисления сходства
            for bnr in bnrs:
                clast_size += 1

                title_body_corr = bnr['title_body_corr'] #для вычисления биграммного сходства

                dist = float(bigr_dist(title_body_corr, title_body)) #вычисление биграммного сходства
                if dist > DIST_MAX:
                    continue;
                #sim = float(word_sim(title_body_corr, title_body)) #вычисление пословного сходства
                sim = 0

                #--- формируем структуру как в users/yuryz/tmp/bnrs_norm, но с двумя дополнительными полями "clast_phrase" и "dist" (см. def neighbor_select) ---
                ctgs = bnr['mctgs_tag'].split('/') #несколько категорий считаются РАЗНЫМИ категориями
                #ctgs = bnr['mctgs_tag'].split('\t') #несколько категорий считаются ОДНОЙ категорией ('\t' - фиктивный разделитель)
                for ctg in ctgs:
                    yield { "clast_phrase": rec['clast_phrase'], "dist": dist, "bid": rec['bid'], "title": rec['title'], "body": rec['body'], "domain": rec['domain'], "mctgs": ctg, "title_norm": rec['title_norm'], "body_norm": rec['body_norm'], "phrases": rec['phrases'], "phrases_norm": rec['phrases_norm'], "title_extension": rec['title_extension'], "title_extension_norm": rec['title_extension_norm'] }

    if clast_size > 0: #таблица для контроля за тем, у каких баннеров нашлись обучающие окрестности
        for bnr in bnrs:
            yield { "mctgs": key['mctgs'], "clast_phrase": key['clast_phrase'], "bid": bnr['bid'], "@table_index": 1 }


def bigr_dist(a, b): #биграммное расстояние
    if a == b: return 0;
    qh = {}
    dst = 0

    a_ = unicode(a, 'utf-8')
    len_a = len(a_)

    b_ = unicode(b, 'utf-8')
    len_b = len(b_)

    for i in range(len_a-1):
        bgr = a_[i]+a_[i+1]
        if bgr in qh:
            qh[bgr] += 1
        else:
            qh[bgr] = 1
        dst += 1

    for i in range(len_b-1):
        bgr = b_[i]+b_[i+1]
        if bgr in qh:
            qh[bgr] -= 1
        else:
            qh[bgr] = -1

        if qh[bgr] < 0:
            dst += 1
        else:
            dst -= 1

    if len_a < len_b:
        dst /= float(len_a)
    else:
        dst /= float(len_b)

    return '%.3f' % dst


def word_sim(a, b): #пословное сходство баннеров
    if a == b: return 0;
    a_wrds = a.split()
    b_wrds = b.split()
    cnt = 0
    for b_wrd in b_wrds:
        if b_wrd in a_wrds: cnt += 1

    return '%.3f' % (1 - float(2 * cnt) / (len(a_wrds) + len(b_wrds)))


def neighbor_select(key, recs): #выбор соседних наиболее близких баннеров
    count = 0
    for rec in recs:
        count += 1
        if count > NEIGHBOR_MAX: break
        del rec['clast_phrase'] #удаляем дополнительные поля
        del rec['dist']
        yield rec


def main():
    tab1 = '//home/catalogia/users/yuryz/contest/ztest_join_categ' #см. categ_sem_core.sh
    tab2 = '//tmp/yuryz/ztest_join_categ_norm'

    yt.run_sort(tab1, tab2, sort_by=['mctgs', 'clast_phrase', 'bid'])

    tab3 = '//home/catalogia/users/yuryz/tmp/bnrs_norm_sense_disamb' #см. core_sense.sh
    tab5 = '//tmp/yuryz/bnrs_corr_clast'
    tab6 = '//tmp/yuryz/clast_size' #таблица ТОЛЬКО для контроля за тем, какие окрестности РЕАЛЬНО сформировались (а для дальнейшей обработки эта таблица не нужна)

    yt.run_reduce(clast_select, [tab2, tab3], [tab5, tab6], reduce_by = ['mctgs', 'clast_phrase'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab5, sort_by=['mctgs', 'clast_phrase', 'dist', 'bid'])
    yt.run_sort(tab6, sort_by=['clast_size', 'mctgs', 'clast_phrase'])

    tab7 = '//home/catalogia/users/yuryz/contest/bnrs_neighbor'

    ##yt.run_reduce(neighbor_select, [tab5], [tab7], reduce_by = ['mctgs', 'clast_phrase'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_reduce(neighbor_select, [tab5], [yt.TablePath(tab7, append=True)], reduce_by = ['mctgs', 'clast_phrase'], format=yt.YsonFormat(control_attributes_mode="row_fields"))

    yt.run_sort(tab7, sort_by=['bid'])

    print >> sys.stderr, yt.row_count(tab6)
    print >> sys.stderr, yt.row_count(tab7)


if __name__ == '__main__':
    main()
