#!/usr/bin/perl -w
#парсинг xml-файла с синтаксическим разбором предложений

use strict;
use utf8;
use open ':utf8';

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");


my %pos = ( #преобразования обычных названий частей речи в обозначения, принятые в mystem
    "UNKNOWNENTRIES" => "S",
    "СУЩЕСТВИТЕЛЬНОЕ" => "S",
    "ПРИЛАГАТЕЛЬНОЕ" => "A",
    "ПРЕДЛОГ" => "PR",
    #"ГЛАГОЛ" => "S", #вместо V, чтобы не было ложных отождествлений
    "ГЛАГОЛ" => "V",
    "БЕЗЛИЧ_ГЛАГОЛ" => "S",
    "ДЕЕПРИЧАСТИЕ" => "ADV",
    "НАРЕЧИЕ" => "ADV",
    "МЕСТОИМ_СУЩ" => "SPRO",
    "МЕСТОИМЕНИЕ" => "PRO",
    "ПРЕФИКС_СОСТАВ_ПРИЛ" => "COM",
    "ПРЕФИКС_СОСТАВ_СУЩ" => "COM",
    "ПРИТЯЖ_ЧАСТИЦА" => "A",
    "ПУНКТУАТОР" => "PUNCT",
    "СОЮЗ" => "CONJ",
    "ЧАСТИЦА" => "PART",
    "ЧИСЛИТЕЛЬНОЕ" => "NUM",
    "NUM_WORD" => "NUM",
);

open F, "parser_dict";
my %parser_dict;
while (<F>) {
    chomp;
    my ($sent, $root, $tree_pos, $tree) = split /\t/;
    $root = lc($root);
    $tree = lc($tree);
    $parser_dict{$sent} = "$root\t$tree_pos\t$tree";
}

my $sent; #текст предложения
my @words; #слова предложения
my @pos; #части речи
my @par; #родители

while (<STDIN>) { #ctg_list_synt2.txt
    chomp;

    next unless $_;
    next if /^<\? /;
    next if /^<parsing>$/;

    if (/^<sentence /) {
        @words = ();
        @pos = ();
        @par = ();
    } elsif (/^<\/sentence>/) {
        if ($sent eq "NCAP Автомобили купе премиум") { #корректиовка парсинга
            @par = (1, -1, 1, 2);
        }

        my $i_root = 0; #индекс опорного слова
        for my $i (0..$#words) { #опорное слово (корень предложения)
            if ($par[$i] == -1) { #индекс родителя
                $i_root = $i;
                #print "$words[$i]\n"; #опорное слово
                last;
            }
        }
        #print join(" ", @words), "\n";
        #print join(" ", @pos), "\n";
        #print join(" ", @par), "\n"; #индексы родителей

        #--- построение дерева зависимостей ---
        my @tree = ($i_root); #собственно дерево, только растет, ',' внутри означает смену ветки
        my @tmp = ($i_root); #список элементов, которые могут быть родителями

        my @par2 = @par; #список элементов, для которых ищутся родители
        $par2[$i_root] = -2; #исключение корня из последующей обработки
        my $cnt_excl = 1; #число исключенных элементов из @par2

        while (1) {
            last if $cnt_excl == @par2; #все элементы @par2 равны -2
            my $parent_found = 0;
            for my $i (0..$#par2) {
                if ($par2[$i] == $tmp[$#tmp]) { #нашли родителя для $i-го слова
                    push @tree, $i;
                    push @tmp, $i;
                    $par2[$i] = -2; #исключение $i-го слова из последующей обработки
                    $cnt_excl++; #число исключенных элементов из @par2
                    $parent_found = 1; 
                    last;
                }
            }

            if ($parent_found == 0) { #переход к следующей ветке
                pop @tmp;
                last unless @tmp;
                push @tree, ","; #признак смены ветки
            }
        }

        my $tree_pos; #дерево частей речи
        my $tree; #дерево слов
        my $op_brack = 0; #число открывающих скобок
        for my $i (0..$#tree) {
            if ($i == 0) {
                if ($pos{$pos[$tree[$i]]}) {
                    $tree_pos = $pos{$pos[$tree[$i]]}; #обозначения частей речи принятые в mystem
                } else {
                    $tree_pos = $pos[$tree[$i]]; #обычные названия частей речи
                }

                #$tree = $tree[$i]; #дерево из индексов слов
                $tree = $words[$tree[$i]]; #дерево из самих слов
            } elsif ($i < $#tree && $tree[$i] eq ',' && $tree[$i+1] eq ',') { #конец ветки
                $tree_pos .= ')';
                $tree .= ')';
                $op_brack--;
            } elsif ($i < $#tree && $tree[$i] eq ',' && $tree[$i+1] ne ',') { #смена ветки
                $tree_pos .= ',';
                $tree .= ',';
            } else {
                if ($i > 0 && $tree[$i-1] ne ',') {
                    $tree_pos .= "(";
                    $tree .= "(";
                    $op_brack++;
                }

                next if $tree[$i] eq ',';

                if ($pos{$pos[$tree[$i]]}) {
                    $tree_pos .= $pos{$pos[$tree[$i]]}; #обозначения частей речи принятые в mystem
                } else {
                    $tree_pos .= $pos[$tree[$i]]; #обычные названия частей речи
                }

                #$tree .= $tree[$i]; #дерево из индексов слов
                $tree .= $words[$tree[$i]]; #дерево из самих слов
            }
        }
        $tree_pos .= ")" x $op_brack;
        $tree .= ")" x $op_brack;


        if ($parser_dict{$sent}) {
            print "$sent\t".$parser_dict{$sent}."\n"; #ГЛАВНАЯ ВЫДАЧА
        } else {
            my $root = lc($words[$i_root]);
            $tree = lc($tree);
            print "$sent\t$root\t$tree_pos\t$tree\n"; #ГЛАВНАЯ ВЫДАЧА
        }
        #print join(" ", @tree), "\n";
        #print "--\n";
    }

    if (/^<text>/) {
        /<text>(.+)<\/text>/;
        $sent = $1;
    }

    if (/^<word/) {
        /<word[^>]*?>(.+)<\/word>/;
        push @words, $1;
    }

    if (/^<part_of_speech>/) {
        /<part_of_speech>(.+)<\/part_of_speech>/;
        if ($words[$#words] =~ /^([Дд]ома)$/) { #корректировка ошибочных частей речи
            push @pos, "СУЩЕСТВИТЕЛЬНОЕ";
        } else {
            push @pos, $1;
        }
    }

    if (/^<node/) {
        /<parent>(.+)<\/parent>/;
        push @par, $1;
    }
}
