#!/usr/bin/python
# -*- coding: utf-8 -*-

#формирование словаря семантических ядер Каталогии

import sys
import re
import math

import yt.wrapper as yt


def sem_core(key, recs): #добавление к семантическому ядру веса, периферии и списка доменов
    flag = 0
    trash = {}
    count = {}
    domain = set()
    for rec in recs:
        if flag == 0: #MAX вес - в ПЕРВОЙ записи
            flag = 1
            clast_weight = float('%.3f' % -rec['clast_weight']) #вес ядра

        T = rec['trash'].split() #пары <слово, вес> - периферия
        for i in range(0, len(T), 2):
            if T[i] in trash:
                trash[T[i]] += float(T[i+1])
                count[T[i]] += 1
            else:
                trash[T[i]] = float(T[i+1])
                count[T[i]] = 1

        domain.add(rec['domain']) #список доменов

    for k in trash: #нормализация весов для слов периферии
        trash[k] = '%d' % (1000 * trash[k] / count[k])
    trash_keys = sorted(trash, lambda x, y: -cmp(int(trash[x]), int(trash[y])) or cmp(x, y) ) #сортировка ПО УБЫВАНИЮ значений ("-" перед cmp)

    T = []
    for k in trash_keys:
        T.append(k)
        T.append(str(trash[k]))

    D = list(domain)
    D.sort()

    yield { "mctgs": key['mctgs'], "clast_phrase": key['clast_phrase'], "clast_weight": clast_weight, "trash": ' '.join(T), "domain": ' '.join(D) }


def uniq(key, recs): #уникализация семантических ядер (чтобы каждое ядро входило ровно в ОДНУ категорию)
    mctgs = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            mctgs = rec['mctgs']
        else:
            if mctgs == '' or mctgs == rec['mctgs']: #уникальные ядра выводятся автоматически, а для неуникальных - проверка совпадения категорий
                yield rec


def add_clast_size(key, recs): #добавление размера кластера к каждому ядру и формирование списка слов, входящих в ядра
    clast_size = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            clast_size = rec['clast_size']
        else:
            if clast_size != 0:
                rec['clast_size'] = clast_size

                core = rec['clast_phrase'].split() #добавление двухсловного индекса
                two_word_index = ''
                if len(core) == 1:
                    two_word_index = core[0]
                else:
                    two_word_index = core[0] + ' ' + core[1]
                rec['two_word_index'] = two_word_index
                yield rec

                for word in core: #формирование списка слов, входящих в ядра
                    yield { "word": word, "@table_index": 1 }


def del_dup(key, recs): #удаление дублей из списка слов, входящих в ядра
    yield recs.next()


def main():
    #--- 1. Добавление к семантическому ядру веса, периферии и списка доменов ---
    tab1 = '//home/catalogia/users/yuryz/tmp/bnrs_norm_sense_disamb' #см. disamb.py
    tab2 = '//tmp/yuryz/sem_core'

    yt.run_reduce(sem_core, tab1, tab2, reduce_by = ['mctgs', 'clast_phrase'])
    yt.run_sort(tab2, sort_by=['clast_phrase', 'mctgs'])

    #--- 2. Уникализация семантических ядер ---
    tab3 = '//home/catalogia/users/yuryz/tmp/core_one' #самые частотные ядра из входящих в несколько категорий (см. clast_size_distr_poli.py)
    tab4 = '//tmp/yuryz/sem_core_uniq' #каждое ядро входит ровно в ОДНУ категорию

    yt.run_reduce(uniq, [tab3, tab2], tab4, reduce_by = ['clast_phrase'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab4, sort_by=['clast_phrase', 'mctgs'])

    #--- 3. Добавление размера кластера к каждому ядру и формирование списка слов, входящих в ядра ---
    tab5 = '//home/catalogia/users/yuryz/tmp/clast_by_phrase' #см. clast_size_distr.py
    tab6 = '//home/catalogia/users/yuryz/tmp/sem_core_clast_size'
    tab7 = '//tmp/yuryz/sem_core_word_list'

    yt.run_reduce(add_clast_size, [tab5, tab4], [tab6, tab7], reduce_by = ['clast_phrase', 'mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab6, sort_by=['two_word_index', 'clast_phrase', 'mctgs'])
    yt.run_sort(tab7, sort_by=['word'])

    #--- 4. Удаление дублей из списка слов, входящих в ядра ---
    tab8 = '//home/catalogia/users/yuryz/tmp/sem_core_word_list'

    yt.run_reduce(del_dup, tab7, tab8, reduce_by = ['word'])
    yt.run_sort(tab8, sort_by=['word'])

    #--- 5. Вывод в файл списка слов, входящих в ядра ---
    for rec in yt.read_table(tab8, raw=False):
        print rec['word']


if __name__ == '__main__':
    main()
