#!/usr/bin/python
# -*- coding: utf-8 -*-

#https://github.com/akutuzov/webvectors/blob/master/preprocessing/rusvectores_tutorial.ipynb

import sys
import re
import math

import requests

#reload(sys)
#sys.setdefaultencoding('utf8')

#https://rusvectores.org/ruscorpora_upos_cbow_300_20_2019/пицца/api/csv/
#ontoid1, ontoid2 = sorted(line.decode('utf-8').split('\t')[:2])

def api_neighbor(m, w, f): #ближайшие соседи
    neighbors = {}
    url = '/'.join(['http://rusvectores.org', m, w, 'api', f]) + '/'
    r = requests.get(url=url, stream=True)
    for line in r.text.split('\n'):
        #print line
        try: # первые две строки в файле -- служебные, их мы пропустим
            word, sim = re.split('\s+', line) # разбиваем строку по одному или более пробелам
            neighbors[word] = sim
            print word, sim
        except:
            continue
    #return neighbors
    return r.text


def api_similarity(m, w1, w2): #сходство двух слов
    url = '/'.join(['https://rusvectores.org', m, w1 + '__' + w2, 'api', 'similarity/'])
    r = requests.get(url, stream=True)
    return r.text.split('\t')[0]


def main():
    #MODEL = 'ruscorpora_upos_cbow_300_20_2019' #НКРЯ
    #MODEL = 'ruwikiruscorpora-func_upos_skipgram_300_5_2019' #НКРЯ и Википедия
    MODEL = 'araneum_none_fasttextcbow_300_5_2018' #Araneum
    FORMAT = 'csv'

    WORD = 'пицца'
    print(api_neighbor(MODEL, WORD, FORMAT))

    WORD = 'сверло'
    MODEL = 'araneum_none_fasttextcbow_300_5_2018'
    print(api_similarity(MODEL, WORD, 'бур_NOUN'))

    while 1:
        try:
            print('Введите два слова или * *')
            w1, w2 = sys.stdin.readline().split()
            if w1 == '*': break
            print(api_similarity(MODEL, w1, w2))
        except:
            print >>sys.stderr, ('Попробуйте ввести еще разок')


if __name__ == '__main__':
    main()
