#!/usr/bin/python
# -*- coding: utf-8 -*-

#подготовка данных для взвешивания слов в категориях с помощью TF_IDF

import sys
import re
import yt.wrapper as yt


def correct_sel(key, recs): #выбор баннеров с корректировочной информацией
    mctgs = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            mctgs = rec['mctgs'] #скорректированная категория
        else:
            if mctgs != '':
                rec['mctgs'] = mctgs
            yield rec


def word_sel(rec): #данные для частотного словаря слов (см. tf_idf_2_3.py)
    bnorm = rec['title_norm'] + ' ' + rec['body_norm']

    L = bnorm.split()
    wrds = set(L) #удаляем дубли
    L = []
    for wrd in wrds:
        wrd = re.sub('^[!+$]+', '', wrd)
        #через без для под про со с
        if len(unicode(wrd, 'utf-8')) <= 1 or re.findall('^([0-9.]+|самовывоз|сегодня|всегда|каждый|минута|нечего|оплата|сейчас|более|здесь|любой|много|стать|также|есть|жать|ваш|где|мес|мин|раз|руб|тут|тыс|час|др|кв|кг|км|м2|мм|пр|см|ул)$', wrd) or re.findall('^_', wrd) or wrd == 'moderatebadwordtype':
            continue
        L.append(wrd)

    ctgs = rec['mctgs'].split('/') #несколько категорий считаются РАЗНЫМИ категориями
    #ctgs = rec['mctgs'].split('\t') #несколько категорий считаются ОДНОЙ категорией ('\t' - фиктивный разделитель)
    for ctg in ctgs:
        for wrd in L:
            yield { "word": wrd, "bid": rec['bid'], "mctgs": ctg }
        yield { "mctgs": ctg, "@table_index": 1 }


def ctg_list(key, recs): #список категорий (D - число документов в коллекции)
    yield recs.next()


def word_filter(key, recs): #фильтрация depricated слов
    ctgs = {}
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            ctgs[rec['mctgs']] = 1
        else:
            if len(ctgs) == 0 or rec['mctgs'] in ctgs:
                yield rec


def main():
    #--- 1. Объединение и сортировка обычных и коррректировочных баннеров ---
    tab_corr = '//home/catalogia/users/yuryz/contest/bnrs_neighbor' #корректировочная таблица баннеров с исправленными категориями (neighbor_sel.py)
    tab0 = '//home/catalogia/users/yuryz/tmp/bnrs_norm'
    tab1 = '//home/catalogia/users/yuryz/bnrs_norm'

    yt.run_reduce(correct_sel, [tab_corr, tab0], tab1, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab1, sort_by='bid') #см. if_idf_4.py

    #--- 2. Выбор слов для частотного словаря ---
    tab2 = '//tmp/yuryz/wrd2ctg'
    tab3 = '//tmp/yuryz/ctg'

    yt.run_map(word_sel, tab1, [tab2, tab3], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab2, sort_by=['word', 'mctgs'])

    #--- 3. Составление списка категорий ---
    tab4 = '//home/catalogia/users/yuryz/tmp/ctg_count'

    yt.run_sort(tab3, sort_by=['mctgs'])
    yt.run_reduce(ctg_list, tab3, tab4, reduce_by = ['mctgs'])
    yt.run_sort(tab4, sort_by=['mctgs'])

    #--- 4. Фильтрация depricated слов ---
    tab5 = '//home/catalogia/users/yuryz/tmp/deprec_expand'
    tab6 = '//home/catalogia/users/yuryz/tmp/wrd2ctg'

    yt.run_reduce(word_filter, [tab5, tab2], tab6, reduce_by = ['word'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab6, sort_by=['word', 'mctgs'])

    print >> sys.stderr, yt.row_count(tab1)
    print >> sys.stderr, yt.row_count(tab2)

    print >> sys.stderr, yt.row_count(tab3)
    print >> sys.stderr, yt.row_count(tab4)

    print >> sys.stderr, yt.row_count(tab5)
    print >> sys.stderr, yt.row_count(tab6)


if __name__ == '__main__':
    main()
