#!/usr/bin/python
# -*- coding: utf-8 -*-

#выделение топа ядер для сравнения категорий по семантике

import sys
import re
import yt.wrapper as yt


def fields_sel(rec): #конвертирование основной таблицы ядер к формату, удобному для сравнения
    yield { "ctg": rec['mctgs'], "topic": rec['two_word_index'], "clust_size": -rec['clast_size'] } #категория, тема, размер кластера


def topic_weight(key, recs): #взвешивание тем
    topics = {}
    total = 0; #общее число баннеров в категории
    for rec in recs:
        if rec['topic'] in topics:
            topics[rec['topic']] += rec['clust_size']
        else:
            topics[rec['topic']] = rec['clust_size']
        total += rec['clust_size']

    for topic in topics:
        weight = float(topics[topic]) / total
        yield { "ctg": rec['ctg'], "topic": topic, "weight": weight, "topic_size": topics[topic], "total_size": total }


def ctgs_cross(key, recs): #пересечение категорий
    ctgs = list(recs)
    if len(ctgs) == 1: return
    for i in range(len(ctgs)-1):
        for j in range(i+1, len(ctgs)):
            min_weight = min(ctgs[i]['weight'], ctgs[j]['weight'])
            yield { "ctg1": ctgs[i]['ctg'], "ctg2": ctgs[j]['ctg'], "topic": key['topic'], "weight": min_weight }
            yield { "ctg1": ctgs[j]['ctg'], "ctg2": ctgs[i]['ctg'], "topic": key['topic'], "weight": min_weight }


def ctgs_proxim(key, recs): #близость категорий
    proxim = 0;
    for rec in recs:
        proxim += rec['weight']
    yield { "ctg1": key['ctg1'], "ctg2": key['ctg2'], "proxim": -proxim }


def ctg_nearest(key, recs): #выбор ближайшей категории
    yield recs.next()


def main():
    tab1 = '//home/catalogia/users/yuryz/tmp/sem_core_clast_size' #таблица семантических ядер
    tab2 = '//home/catalogia/users/yuryz/compare/sem_cores'

    #yt.run_map(fields_sel, tab1, tab2, format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab2, sort_by=['ctg', 'topic', 'clust_size'])

    tab3 = '//home/catalogia/users/yuryz/compare/topic_weight' #темы с относительным весом внутри категорий

    #yt.run_reduce(topic_weight, tab2, tab3, reduce_by = ['ctg'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab3, sort_by=['topic', 'ctg', 'weight'])

    tab4 = '//home/catalogia/users/yuryz/compare/ctg_cross' #пересечение пар категорий по темам

    #yt.run_reduce(ctgs_cross, tab3, tab4, reduce_by = ['topic'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab4, sort_by=['ctg1', 'ctg2', 'topic'])

    tab5 = '//home/catalogia/users/yuryz/compare/ctg_proxim' #близость категорий

    #yt.run_reduce(ctgs_proxim, tab4, tab5, reduce_by = ['ctg1', 'ctg2'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab5, sort_by=['ctg1', 'proxim', 'ctg2'])

    tab6 = '//home/catalogia/users/yuryz/compare/ctg_nearest' #ближайшая категория

    #yt.run_reduce(ctg_nearest, tab5, tab6, reduce_by = ['ctg1'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab6, sort_by=['ctg1'])
    ##yt.run_sort(tab6, sort_by=['proxim', 'ctg1'])


if __name__ == '__main__':
    main()
