#!/usr/bin/python
# -*- coding: utf-8 -*-

#выбор 10 главных соседей для каждой категории Каталогии

import sys
import re
import yt.wrapper as yt


def neibor_10(key, recs): #выбор 10 ближайших соседей
    count = 0
    for rec in recs:
        yield rec
        count += 1
        if count >= 10: break


def main():
    tab5 = '//home/catalogia/users/yuryz/compare/ctg_proxim' #близость категорий
    tab6 = '//home/catalogia/users/yuryz/compare/neibor_10' #ближайшие категории

    #yt.run_reduce(neibor_10, tab5, tab6, reduce_by = ['ctg1'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab6, sort_by=['ctg1', 'proxim'])

    for rec in yt.read_table(tab6, raw=False):
        print rec['ctg1'] + '\t' + rec['ctg2']


if __name__ == '__main__':
    main()
