#!/usr/bin/perl -w
#формирование мультимножеств для категорий

use strict;
use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

#use FindBin;
#use lib "$FindBin::Bin/../lib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";

use Utils::Common;
use Project;
use BM::Phrase;
use BM::PhraseList;
use Time::HiRes qw(tv_interval gettimeofday);

my $proj = Project->new({
    load_dicts => 1,
    load_minicategs_light => 1,
});


while (<STDIN>) { #contest_data_unit
    chomp;
    my ($bid, $title, $body, $domain, $mctgs) = split /\t/;

    my @mctgs_anc;
    my @ctgs = split m{/}, $mctgs;
    my $cnt = 0; #количество элементов мультимножества
    my %dic; #частотный словарь категорий (мультимножество)
    for my $ctgs (@ctgs) {
        my $anc = ancestors_add($ctgs); #предки категории
        my @anc = split m{/}, $anc;
        for (@anc) {
            $cnt++;
            $dic{$_}++;
        }

        push @mctgs_anc, $anc; #добавление предков для категории
    }
    #print "$bid\t$mctgs\t", join("*", @mctgs_anc), "\n";
    my @pairs;
    for (sort keys %dic) {
        push @pairs, "$_\t$dic{$_}"; #пары <категория, частота>
    }
    #print "$bid\t$mctgs\t", join("*", @mctgs_anc), "\t$cnt\t", join("*", @pairs), "\n";
    print "$bid\t$cnt\t", join("\t", @pairs), "\n";
}


#--- добавление предков для категории ---
sub ancestors_add {
    my ($categ) = @_;

    my @ancestors; #все предки категории
    my $ancestor = $categ;
    while ($ancestor = $proj->categs_tree->get_minicateg_parent($ancestor)) {
        push @ancestors, $ancestor;
    }

    return join("/", reverse @ancestors)."/$categ";
}
