#!/usr/bin/python
# -*- coding: utf-8 -*-

#печать виртуальных категорий, расположенных на дереве Каталогии ближе к такой же виртуальной родителя, чем к своей невиртуальной

import sys
import re
import yt.wrapper as yt


def ctgs_pair(key, recs):
    ctg1 = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            ctg1 = key['ctg1']
        elif ctg1 != '':
            rec['proxim'] = -rec['proxim']
            yield rec


def ctgs_select(key, recs): #отбор виртуальных категорий для переноса
    ctgs = list(recs)
    if len(ctgs) != 2: return

    if re.search(r' _ ', ctgs[0]['ctg2']): #виртуальный родитель
        sim_parent = ctgs[0]['proxim']
        ctg_parent = ctgs[0]['ctg2']
        sim_non_virt = ctgs[1]['proxim']
        ctg_non_virt = ctgs[1]['ctg2']
    else:
        sim_parent = ctgs[1]['proxim']
        ctg_parent = ctgs[1]['ctg2']
        sim_non_virt = ctgs[0]['proxim']
        ctg_non_virt = ctgs[0]['ctg2']

    if sim_parent > sim_non_virt: #кандидат для переноса (сходство с виртуальный родителем больше, чем с собственой невиртуальной категорией)
        yield { "ctg_virt": key['ctg1'], "ctg_parent": ctg_parent, "sim_parent": sim_parent, "ctg_non_virt": ctg_non_virt, "sim_non_virt": sim_non_virt }


def main():
    tab1 = '//tmp/yuryz/ctgs_pair'
    tab2 = '//home/catalogia/users/yuryz/compare/ctg_proxim'
    tab3 = '//tmp/yuryz/ctgs_pair_sim' #пары категорий с семантической близостью

    #yt.run_reduce(ctgs_pair, [tab1, tab2], tab3, reduce_by = ['ctg1', 'ctg2'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab3, sort_by=['ctg1', 'ctg2'])

    tab4 = '//home/catalogia/users/yuryz/compare/virt_for_transfer' #категории-кандидаты на перенос в виртуальную родительскую

    #yt.run_reduce(ctgs_select, [tab3], tab4, reduce_by = ['ctg1'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab4, sort_by=['ctg_virt', 'ctg_parent', 'sim_parent', 'ctg_non_virt'])


if __name__ == '__main__':
    main()
