#!/usr/bin/perl -w
#ранжирование категорий в соответствии с распределением обучающих баннеров

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");


use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


open F, "zbnrs_rank_max"; #составлен по TrainExact
my %rank;
my %ctg;
while (<F>) {
    chomp;
    my ($bid, $ctg, $weight) = split /\t/;
    $rank{$bid} = $weight;
    $ctg{$bid} = $ctg;
}

open F, "zqual";
chomp (my @zqual = <F>);

$| = 1; #отключение буферизации вывода

open F, "zexp_corr";
my %sign;
while (<F>) {
    chomp;
    my ($sim, $rank, $ctg) = split /\t/;
    $sign{"$sim\t$rank\t$ctg"} = 1;
}


my %dup;
for my $j (0..$#zqual) {
    my ($bidJ, $ctg_goodJ, $ctg_badJ, $cntJ) = split /\t/, $zqual[$j];

    next if $cntJ >= 2;
    next if $dup{$ctg_badJ};
    $dup{$ctg_badJ} = 1;

    my $rate_max = 0;
    my $sim_max = 0;
    my $rank_max = 0;
    my $total_max = 0;
    my $guess_max = 0;

    for my $sim (0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0) {
        for my $rank (100, 150, 200, 250, 300, 350, 400, 450, 500, 550, 600) {
            my ($total, $guess) = (0, 0);
            for my $i (0..$#zqual) {
                my ($bid, $ctg_good, $ctg_bad, $cnt) = split /\t/, $zqual[$i];

                next if $cnt >= 2;
                next if $ctg_bad ne $ctg_badJ;

                if ($rank{$bid}) {
                    my $ctg_sim = ctgs_sim($ctg_bad, $ctg{$bid});
                    if ($ctg_sim <= $sim && $rank{$bid} >= $rank) {
                        $total++;
                        $guess++ if $ctg_good eq $ctg{$bid};

                        if ($sign{"$sim\t$rank\t$ctg_bad"}) { #вывод данных для zexp2.pl
                            print "$bid\t$ctg{$bid}\n";
                        }
                    }
                }
            }

            my $rate = $total > 0 ? sprintf("%.3f", 1.0*$guess/$total) : 0;
            if ($rate_max < $rate) {
                $rate_max = $rate;
                $sim_max = $sim;
                $rank_max = $rank;
                $total_max = $total;
                $guess_max = $guess;
            }
            #print STDERR "SIM=$sim\tRANK=$rank\tTOTAL=$total\tGUESS=$guess\t$rate\n";
        }
    }
    print STDERR "$sim_max\t$rank_max\t$ctg_badJ\tRATE=$rate_max\tTOTAL=$total_max\tGUESS=$guess_max\n"if $rate_max > 0.5;
}


#--- вычисление сходства между мультимножествами автокатегории и категорией ядра ---
sub ctgs_sim {
    my ($AutoCategoryNames, $CoreCategoryNames) = @_;

    my $AutoMS = mset($AutoCategoryNames); #мультимножество автокатегории
    my ($countI, @pairsI) = split /\t/, $AutoMS;
    my %dicI; #мультимножество (частотный словарь)
    for (my $i2 = 0; $i2 <= $#pairsI-1; $i2 += 2) { #
        $dicI{$pairsI[$i2]} = $pairsI[$i2+1]
    }

    my $CoreMS = mset($CoreCategoryNames); #мультимножество категории ядра
    my ($countJ, @pairsJ) = split /\t/, $CoreMS;
    my $cross = 0; #пересечение множеств
    for (my $j2 = 0; $j2 <= $#pairsJ-1; $j2 += 2) { #
        if ($dicI{$pairsJ[$j2]}) {
            $cross += $dicI{$pairsJ[$j2]} <= $pairsJ[$j2+1] ? $dicI{$pairsJ[$j2]} : $pairsJ[$j2+1]; #min частота
        }
    }

    my $sim = sprintf("%.3f", 2.0 * $cross / ($countI + $countJ));

    return $sim;
}


#--- вычисление мультимножества ---
sub mset {
    my ($mctgs) = @_;

    my @ctgs = split m{/}, $mctgs;
    my $cnt = 0; #количество элементов мультимножества
    my %dic = (); #частотный словарь категорий (мультимножество)

    for my $ctgs (@ctgs) {
        my $anc = ancestors_add($ctgs); #предки категории
        my @anc = split m{/}, $anc;
        for (@anc) {
            $cnt++;
            $dic{$_}++;
        }
    }

    my @pairs = ();
    for (sort keys %dic) {
        push @pairs, "$_\t$dic{$_}"; #пары <категория, частота>
    }

    return "$cnt\t".join("\t", @pairs); #мультимножество
}


#--- добавление предков для категории ---
sub ancestors_add {
    my ($categ) = @_;

    my @ancestors; #все предки категории
    my $ancestor = $categ;
    while ($ancestor = $proj->categs_tree->get_minicateg_parent($ancestor)) {
        push @ancestors, $ancestor;
    }

    return join("/", reverse @ancestors)."/$categ";
}
