#!/usr/bin/python
# -*- coding: utf-8 -*-

#снятие омонимии семантических ядер

import sys
import re
import math

import yt.wrapper as yt


def clast_size(key, recs): #определение размеров кластеров
    mctgs_prev = ''
    flag = 0
    for rec in recs:
        if mctgs_prev == '':
            mctgs_prev = rec['mctgs']
            clast_size = 1
        elif mctgs_prev == rec['mctgs']:
            clast_size += 1
        else:
            flag = 1
            yield { "clast_phrase": key['clast_phrase'], "mctgs": mctgs_prev, "clast_size": -clast_size} #ЭТОТ ОПЕРАТОР ЗАКОММЕНТИРОВАТЬ при выводе ОДНОЗНАЧНЫХ категорий
            mctgs_prev = rec['mctgs']
            clast_size = 1
    if flag == 1: # 0 - однозначные категории для clast_phrase, 1 - омонимичные (clast_phrase входит в несколько категорий)
        yield { "clast_phrase": key['clast_phrase'], "mctgs": mctgs_prev, "clast_size": -clast_size }


def add_clast_size(key, recs): #добавление размеров кластеров к записям bnrs_norm_sense
    clast_size = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            clast_size = rec['clast_size']
        else:
            rec['clast_size'] = clast_size
            yield rec


def core_expand(key, recs): #расширение ядра у баннеров, не входящих в max кластер
    flag = 0
    for rec in recs:
        if flag == 0:
            flag = 1
            mctgs = rec['mctgs']
        if mctgs != rec['mctgs']: #добавляем одно слово к ядру из трэша
            L = rec['clast_phrase'].split()
            M = rec['trash'].split()
            if len(M) > 0:
                word = M.pop(0)
                L.append(word)
                core = ' '.join(L)
                trash = ' '.join(M)

                yield { "mctgs": rec['mctgs'], "clast_size": rec['clast_size'], "clast_phrase_old": rec['clast_phrase'], "clast_phrase": core, "trash_old": rec['trash'], "trash": trash, "@table_index": 1 } #список выполненных изменений

                rec['clast_phrase'] = core
                rec['trash'] = trash

        rec['@table_index'] = 0
        yield rec


def main():
    tab1 = '//home/catalogia/users/yuryz/tmp/bnrs_norm_sense' #исходные данные для снятия омонимии
    tab2 = '//tmp/yuryz/bnrs_norm_sense_disamb'
    if yt.exists(tab2):
        yt.remove(tab2)
    yt.copy(tab1, tab2)

    while 1:
        print "1. СОРТИРОВКА ИСХОДНОЙ ТАБЛИЦЫ, В КОТОРОЙ ДОЛЖНА СНИМАТЬСЯ ОМОНИМИЯ"
        yt.run_sort(tab2, sort_by=['clast_phrase', 'mctgs'])
        print tab2 + ' = ' + str(yt.row_count(tab2))

        print "2. ОПРЕДЕЛЕНИЕ РАЗМЕРОВ ОМОНИМИЧНЫХ КЛАСТЕРОВ"
        tab3 = '//tmp/yuryz/bnrs_clast_size' #ядра, входящие в несколько категорий
        yt.run_reduce(clast_size, tab2, tab3, reduce_by = 'clast_phrase')
        yt.run_sort(tab3, sort_by=['clast_phrase', 'mctgs'])
        print tab3 + ' = ' + str(yt.row_count(tab3))

        print "3. ДОБАВЛЕНИЕ РАЗМЕРОВ ОМОНИМИЧНЫХ КЛАСТЕРОВ К ЗАПИСЯМ ИСХОДНОЙ ТАБЛИЦЫ"
        tab4 = '//tmp/yuryz/bnrs_norm_sense_size'
        yt.run_reduce(add_clast_size, [tab3, tab2], [tab4], reduce_by = ['clast_phrase', 'mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
        yt.run_sort(tab4, sort_by=['clast_phrase', 'clast_size', 'mctgs', 'bid'])
        print tab4 + ' = ' + str(yt.row_count(tab4))

        print "4. РАСШИРЕНИЕ ЯДРА У БАННЕРОВ, НЕ ВХОДЯЩИХ В MAX КЛАСТЕР"
        tab5 = '//tmp/yuryz/core_expand' #расширение ядра у баннеров, не входящих в max кластер
        tab6 = '//tmp/yuryz/trash2core' #список выполненных изменений
        yt.run_reduce(core_expand, tab4, [tab5, tab6], reduce_by = ['clast_phrase'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
        yt.run_sort(tab5, sort_by=['clast_phrase', 'mctgs']) #в этой таблице, в конечном итоге, и будут ОКОНЧАТЕЛЬНЫЕ результаы
        yt.run_sort(tab6, sort_by=['clast_phrase', 'clast_size', 'mctgs']) #нужно только для УДОБСТВА отладки
        print tab5 + ' = ' + str(yt.row_count(tab5))
        print tab6 + ' = ' + str(yt.row_count(tab6))

        if yt.row_count(tab6) == 0:
            break

        yt.remove(tab2)
        yt.copy(tab5, tab2)

    tab_res = '//home/catalogia/users/yuryz/tmp/bnrs_norm_sense_disamb'
    yt.run_sort(tab5, tab_res, sort_by=['mctgs', 'clast_phrase', 'clast_weight', 'bid'])


if __name__ == '__main__':
    main()
