#!/usr/bin/python
# -*- coding: utf-8 -*-

#добавление TF_IDF к таблице wrd2ctg, сборка баннеров и нормализация весов

import math
import yt.wrapper as yt


def add_tf_idf(key, recs): #добавление TF_IDF к таблице wrd2ctg
    tf_idf = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            tf_idf = rec['tf_idf']
        else:
            rec['tf_idf'] = tf_idf
            yield rec


THRESHOLD = 0.96 #min порог для формирования кластерообразующей фразы

def bnr_assem(key, recs): #сборка баннеров и нормализация весов
    L = list(recs)
    sum = 0
    for rec in L:
        sum += rec['tf_idf']

    core = {}
    for rec in L:
        if sum > 0:
            core[rec['word']] = '%.3f' % (rec['tf_idf'] / sum)
        else:
            core[rec['word']] = 0

    sorted_keys = sorted(core, lambda x, y: -cmp(float(core[x]), float(core[y]))) #сортировка ПО УБЫВАНИЮ значений ("-" перед cmp)
    sense = []
    for word in sorted_keys:
        sense.append(word)
        sense.append(str(core[word]))

    clast_phrase = []
    clast_weight = 0
    trash = []
    for i in range(0, len(sense), 2):
        if clast_weight < THRESHOLD:
            clast_phrase.append(sense[i]) #слова, образующие СЕМАНТИЧЕСКОЕ ЯДРО
            clast_weight += float(sense[i+1])
        else:
            trash.append(sense[i]) #слова, образующие ПЕРИФЕРИЮ

    yield { "bid": key['bid'], "sense": ' '.join(sense), "mctgs": L[0]['mctgs'], "clast_phrase": ' '.join(clast_phrase), "clast_weight": -clast_weight, "trash": ' '.join(trash) }


def add_sense(key, recs): #добавление смыслового ядра к таблице bnrs_norm
    sense = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            sense = rec['sense']
            clast_phrase = rec['clast_phrase']
            clast_weight = rec['clast_weight']
            trash = rec['trash']
        else:
            if sense != '':
                rec['sense'] = sense
                rec['clast_phrase'] = clast_phrase
                rec['clast_weight'] = clast_weight
                rec['trash'] = trash
                yield rec


def main():
    #--- 1. Добавление TF_IDF к таблице wrd2ctg ---
    tab1 = '//home/catalogia/users/yuryz/tmp/wrd_ctg_tf_idf'
    tab2 = '//home/catalogia/users/yuryz/tmp/wrd2ctg'
    tab3 = '//home/catalogia/users/yuryz/tmp/wrd2ctg_weight'

    yt.run_reduce(add_tf_idf, [tab1, tab2], tab3, reduce_by = ['word', 'mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab3, sort_by=['bid', 'word', 'mctgs'])

    #--- 2. Сборка баннеров и нормализация весов ---
    tab4 = '//home/catalogia/users/yuryz/tmp/bnr2tf_idf'

    yt.run_reduce(bnr_assem, tab3, tab4, reduce_by = 'bid')
    yt.run_sort(tab4, sort_by=['bid'])

    #--- 3. Добавление смыслового ядра к таблице bnrs_norm ---
    tab5 = '//tmp/yuryz/bnrs_norm' #см. if_idf_1.py
    tab6 = '//home/catalogia/users/yuryz/tmp/bnrs_norm_sense'

    yt.run_reduce(add_sense, [tab4, tab5], tab6, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab6, sort_by=['mctgs', 'clast_phrase', 'clast_weight', 'bid'])

    print yt.row_count(tab1)
    print yt.row_count(tab2)
    print yt.row_count(tab3)

    print yt.row_count(tab4)

    print yt.row_count(tab5)
    print yt.row_count(tab6)


if __name__ == '__main__':
    main()
