#!/usr/bin/perl -w
# биграммное расстояние между строками
use strict;

use utf8;
use open ':utf8';

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

$a = '3d c moderatebadwordtype myriwell гарантия год доставка егодня нижний новгород платить после проверка ручка самовывоз сегодня';
$b = '3d c lcd moderatebadwordtype myriwell гарантия год доставка егодня нижний новгород платить после проверка ручка самовывоз сегодня';
$b = '!3d 20см 3d 3d-принтер uniqbot дешевый объект печать принтер простой сложный';
$b = '3d c moderatebadwordtype myriwell гарантия год доставка егодня нижний новгород платить после проверка ручка самовывоз сегодня';
$a = 'Привет';
$b = 'привет';
$a = "Оптом и в розницу стальной круг.";
$b = "Оптом и в стальной розницу";

print "$a\n";
print "$b\n";

my $dst = qgr_dst($a, $b);
print "$dst\n";
$dst /= length($a) < length($b) ? length($a) : length($b);

print "$dst\n";
print 1 - $dst, "\n";

# ----- вычисление q-граммного расстояния -----
sub qgr_dst {
    my ($s1, $s2) = @_;
    my (%qh, $dst);
    
    qgr_cnt($s1, \%qh, 0, \$dst);
    qgr_cnt($s2, \%qh, 1, \$dst);
    
    return $dst;
}


# ----- подсчет q-грамм -----
sub qgr_cnt {
    my ($s, $qh, $flag, $dst) = @_;

    my $q = 2; # длина q-граммы
    
    my $k = $q - length($s);
    $k = 0 if $k < 0;
    $s .= " " x $k; # дополнение коротких строк пробелами
    
    while ($s =~ /(.{$q,$q})/g) { # разбиение строки на q-граммы
        !$flag ? $$qh{$1}++ : $$qh{$1}--;
        !$flag || $$qh{$1} < 0 ? $$dst++ : $$dst--; # расстояние
        pos($s) -= $q - 1;
    }
}
