#!/usr/bin/env bash
# формирование словаря семантических ядер баннеров Каталогии

#--- I. Первичная обработка баннеров
# (* ОБЫЧНЫЕ БАННЕРЫ *)
#python bnrs_select.py 1 //tmp/yuryz/bnrs_uniq #FROM: //home/catalogia/banners_extended TO: //tmp/yuryz/bnrs_uniq
#bnrs_norm_main.pl //tmp/yuryz/bnrs_uniq //tmp/yuryz/bnrs_norm #(bnrs_norm_map.pl) - выделение и нормализация смыслового ядра баннеров
#python bnrs_bid2int.py //tmp/yuryz/bnrs_norm //home/catalogia/users/yuryz/bnrs_norm

# (* ОМОНИМЫ *)
#python bnrs_select.py 2 //tmp/yuryz/bnrs_hom_uniq #FROM: //home/catalogia/banners_extended TO: //tmp/yuryz/bnrs_hom_uniq
#bnrs_norm_main.pl //tmp/yuryz/bnrs_hom_uniq //tmp/yuryz/bnrs_hom_norm
#python bnrs_bid2int.py //tmp/yuryz/bnrs_hom_norm //home/catalogia/users/yuryz/bnrs_hom_norm

# --- II. Построение таблицы семантических ядер баннеров Каталогии //home/catalogia/users/yuryz/tmp/bnrs_norm_sense ---
#python tf_idf_1.py #при учете ОМОНИМОВ, здесь НУЖНО указывать в маппере 2 таблицы (работает около 2-х часов!!!)
#python tf_idf_2.py
#python tf_idf_3.py #здесь формируется словарь wrd_ctg_tf_idf
#python tf_idf_4.py #порог = 0.96, СОЗДАЕТ bnrs_norm_sense

# --- III. ИТЕРАЦИОННАЯ дизамбигуация (ядра с MAX кластерами на каждой итерации остаются неизменными, а остальные ядра расширяются из трэша пословно) ---
#bash disamb.sh

# --- IV. Построение семантического словаря Каталогии <core_index_id, two_word_index> ---
python clast_size_distr.py //home/catalogia/users/yuryz/tmp/bnrs_norm_sense_disamb #СОЗДАЕТ clast_by_phrase (число строк = числу ядер)

python read_core_index.py >core_index_id #ИСПОЛЬЗУЕТ core_one (clast_size_distr_poli.py) и clast_by_phrase (clast_size_distr.py)
two_word_index.pl <core_index_id >two_word_index

# --- V. Построение словаря слов Каталогии, входящих в ее семантический словарь core_index ---
perl -ne '{@a=split/\t/;@b=split/ /,$a[0];print "$_\n"for @b}' core_index_id |LC_ALL=C sort -u >word_filter
