#!/usr/bin/python
# -*- coding: utf-8 -*-

#снятие омонимии семантических ядер

import sys
import re
import math

import yt.wrapper as yt


def clast_size(key, recs): #определение размеров кластеров
    mctgs_prev = ''
    flag = 0
    for rec in recs:
        if mctgs_prev == '':
            mctgs_prev = rec['mctgs']
            clast_size = 1
        elif mctgs_prev == rec['mctgs']:
            clast_size += 1
        else:
            flag = 1
            yield { "clast_phrase": key['clast_phrase'], "mctgs": mctgs_prev, "clast_size": -clast_size} #ЭТОТ ОПЕРАТОР ЗАКОММЕНТИРОВАТЬ при выводе ОДНОЗНАЧНЫХ категорий
            mctgs_prev = rec['mctgs']
            clast_size = 1
    if flag == 1: # 0 - однозначные категории для clast_phrase, 1 - омонимичные (clast_phrase входит в несколько категорий)
        yield { "clast_phrase": key['clast_phrase'], "mctgs": mctgs_prev, "clast_size": -clast_size }


def add_clast_size(key, recs): #добавление размеров кластеров к записям bnrs_norm_sense
    clast_size = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            clast_size = rec['clast_size']
        else:
            if clast_size != 0:
                yield { "bid": rec['bid'], "clast_phrase": key['clast_phrase'], "trash": rec['trash'], "mctgs": key['mctgs'], "clast_size": clast_size, "@table_index": 0}
            else:
                yield { "bid": rec['bid'], "clast_phrase": key['clast_phrase'], "trash": rec['trash'], "mctgs": key['mctgs'], "clast_size": clast_size, "@table_index": 1 } #РЕЗУЛЬТАТЫ ДИЗАМБИГУАЦИИ


def del_max_size(key, recs): #удаление баннеров, содержащих ядра с MAX кластерами (у них ТЕКУЩЕЕ ядро НЕ МЕНЯЕТСЯ)
    flag = 0
    for rec in recs:
        if flag == 0:
            flag = 1
            mctgs = rec['mctgs']
        if mctgs != rec['mctgs']: #добавляем одно слово к ядру из трэша
            L = rec['clast_phrase'].split()
            M = rec['trash'].split()
            if len(M) > 0:
                word = M.pop(0)
                L.append(word)
                yield { "mctgs": rec['mctgs'], "clast_size": rec['clast_size'], "clast_phrase_old": rec['clast_phrase'], "clast_phrase": ' '.join(L), "trash_old": rec['trash'], "trash": ' '.join(M), "@table_index": 2 } #список выполненных изменений

            rec['clast_phrase'] = ' '.join(L)
            rec['trash'] = ' '.join(M)
            rec['@table_index'] = 0 #кандидаты для дизамбигуации на следующей итерации (0 - теперь указывать ОБЯЗАТЕЛЬНО)
        else:
            rec['@table_index'] = 1 #РЕЗУЛЬТАТЫ ДИЗАМБИГУАЦИИ

        yield rec


def add_disamb(key, recs): #добавление результатов дизамбигуации к таблице bnrs_norm_sense (ОМОНИМИЯ снимается у КОНКРЕТНЫХ баннеров на уровне bid!!!)
    disamb = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            disamb = rec['clast_phrase']
            trash = rec['trash']
        else:
            if disamb != '':
                rec['clast_phrase'] = disamb #новое значение
                rec['trash'] = trash #новое значение
            yield rec


def main():
    tab0 = sys.argv[1] #//home/catalogia/users/yuryz/tmp/bnrs_norm_sense_disamb (см. disamb.sh)

    tab1 = tab0
    tab2 = '//tmp/yuryz/bnrs_norm_sense'

    tab_res = '//tmp/yuryz/core_disamb' #РЕЗУЛЬТАТ ДИЗАМБИГУАЦИИ ЯДЕР (в конечном итоге размер должен совпадать с исходной таблицей '//home/catalogia/users/yuryz/tmp/bnrs_norm_sense')
    if yt.exists(tab_res):
        yt.remove(tab_res)

    while 1: #локальная итерация (глобальная - в disamb.sh)
        print "1. СОРТИРОВКА ИСХОДНОЙ ТАБЛИЦЫ, В КОТОРОЙ ДОЛЖНА СНИМАТЬСЯ ОМОНИМИЯ"
        yt.run_sort(tab1, tab2, sort_by=['clast_phrase', 'mctgs'])
        print tab1 + ' = ' + str(yt.row_count(tab1))
        print tab2 + ' = ' + str(yt.row_count(tab2))

        print "2. ОПРЕДЕЛЕНИЕ РАЗМЕРОВ ОМОНИМИЧНЫХ КЛАСТЕРОВ"
        tab3 = '//tmp/yuryz/bnrs_clast_size' #ядра, входящие в несколько категорий
        yt.run_reduce(clast_size, tab2, tab3, reduce_by = 'clast_phrase')
        yt.run_sort(tab3, sort_by=['clast_phrase', 'mctgs'])
        print tab3 + ' = ' + str(yt.row_count(tab3))

        print "3. ДОБАВЛЕНИЕ РАЗМЕРОВ ОМОНИМИЧНЫХ КЛАСТЕРОВ К ЗАПИСЯМ ИСХОДНОЙ ТАБЛИЦЫ"
        tab4 = '//tmp/yuryz/bnrs_norm_sense_size'
        yt.run_reduce(add_clast_size, [tab3, tab2], [tab4, yt.TablePath(tab_res, append=True)], reduce_by = ['clast_phrase', 'mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
        yt.run_sort(tab4, sort_by=['clast_phrase', 'clast_size', 'mctgs', 'bid'])
        print tab4 + ' = ' + str(yt.row_count(tab4))
        print tab_res + ' = ' + str(yt.row_count(tab_res))

        print "4. УДАЛЕНИЕ БАННЕРОВ, СОДЕРЖАЩИХ ЯДРА С MAX КЛАСТЕРАМИ"
        tab5 = '//tmp/yuryz/del_max_size' #удаление баннеров, содержащих ядра с MAX кластерами
        tab6 = '//tmp/yuryz/trash2core' #список слов из трэшей, перенесенных в ядра для снятия омонимии

        yt.run_reduce(del_max_size, tab4, [tab5, yt.TablePath(tab_res, append=True), tab6], reduce_by = ['clast_phrase'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
        yt.run_sort(tab5, sort_by=['clast_phrase', 'mctgs']) #для цикла

        yt.run_sort(tab6, sort_by=['clast_phrase', 'clast_size', 'mctgs']) #нужно только ДЛЯ ОТЛАДКИ

        print tab_res + ' = ' + str(yt.row_count(tab_res))
        print tab5 + ' = ' + str(yt.row_count(tab5))
        print tab6 + ' = ' + str(yt.row_count(tab6))

        if yt.row_count(tab6) == 0:
            break

        tab1 = tab5

    print "5. ОБЪЕДИНЕНИЕ РЕЗУЛЬТАТОВ СНЯТИЯ ОМОНИМИИ"
    disamb = '//tmp/yuryz/disamb'
    yt.run_merge([tab_res, tab5], disamb, mode='unordered')
    yt.run_sort(disamb, sort_by=['bid']) #ОМОНИМИЯ снимается у КОНКРЕТНЫХ баннеров на уровне bid!!!
    print 'ИТОГ: ' + str(yt.row_count(disamb))

    print "6. ДОБАВЛЕНИЕ РЕЗУЛЬТАТОВ СНЯТИЯ ОМОНИМИИ В ИСХОДНУЮ ТАБЛИЦУ"
    yt.run_sort(tab0, tab2, sort_by=['bid'])
    tab7 = '//home/catalogia/users/yuryz/tmp/bnrs_norm_sense_disamb' #результаты снятия омонимии
    yt.run_reduce(add_disamb, [disamb, tab2], tab7, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab7, sort_by=['mctgs', 'clast_phrase', 'clast_weight', 'bid'])


if __name__ == '__main__':
    main()
