#!/usr/bin/perl -w
#перевод арифметического выражения из инфиксной в постфиксную (RPN = "Reverse Polish notation") запись (алгоритм Дейкстры)
#http://trubetskoy1.narod.ru/ppn.html

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

my $exp = "a+(b-c)*d"; #исходное (инфиксное) выражение

my $exp1 = "(a+b+c+d)*(e+f+g)*(h+i)";
my $exp2 = "a*e+a*f+b*d+b*e+c*d+c*e";

my $exp3 = "(a+c)*(d+e)+b*e"; #исходное (инфиксное) выражение
#my $exp4 = "a*d+a*e+c*d+c*e+b*e"; #исходное (инфиксное) выражение
my $exp4 = "a*d+a*e+b*e+c*d+c*e"; #исходное (инфиксное) выражение

my @rpn = to_rpn($exp1); #перевод в обратную польскую запись
my $rpn = join("", @rpn);
#print "'$exp1' => $rpn'\n";

@rpn = to_rpn($exp2); #перевод в обратную польскую запись
$rpn = join("", @rpn);
#print "'$exp2' => $rpn'\n";

@rpn = to_rpn($exp3); #перевод в обратную польскую запись
$rpn = join("", @rpn);
#print "'$exp3' => $rpn'\n";

@rpn = to_rpn($exp4); #перевод в обратную польскую запись
$rpn = join("", @rpn);
#print "'$exp4' => $rpn'\n";


my @exp = from_rpn(\@rpn); #перевод из обратной польской записи
$exp = join("", @exp);
#print "'$rpn' => $exp'\n";

#---------------------------------
my $tree = "a*b*(c*f+d*g*k*m+e*(h+i*l+j))";
$tree = "a*(b*(e*g+f*(l+m))+c)";
@rpn = to_rpn($tree); #перевод в обратную польскую запись
$rpn = join("", @rpn);
print "'$tree' => '$rpn'\n";

@exp = from_rpn(\@rpn); #перевод из обратной польской записи
$exp = join("", @exp);
print "'$rpn' => '$exp'\n";
#---------------------------------


#--- перевод из инфиксной записи в постфиксную ---
sub to_rpn {
    my ($exp) = @_;

    my @rpn;

    my $nam = "[a-z0-9]+"; #имя
    my $re = "($nam|[()*+-])"; #выделение токенов
    my @op; #стек операций 

    while ($exp =~ /$re/g) {
        my $tok = $1; #токен
        if ($tok =~ /^$nam$/) { #имя
            push @rpn, $tok;
        } elsif ($tok =~ /^[(*]$/) { #умножение или "("
            push @op, $tok;
        } elsif ($tok =~ /^[+-]$/) { #сложение/вычитание
            if (@op && $op[$#op] eq "*") { #запись с более высоким приоритетом
                while (@op && $op[$#op] eq "*") {
                    push @rpn, pop @op;
                }
            }
            push @op, $tok;
        } elsif ($tok eq ")") { #")"
            while ($op[$#op] ne "(") {
                push @rpn, pop @op;
            }
            pop @op ; #удаляем "("
        }
    }

    while (@op) { #опустошаем стек
        push @rpn, pop @op;
    }

    return @rpn;
}


#--- перевод из постфиксной записи в инфиксную ---
sub from_rpn {
    my ($rpn) = @_;

    my $nam = "[a-z0-9]+"; #имя

    my @exp;
    for my $tok (@$rpn) {
        if ($tok =~ /^$nam$/) { #имя
            push @exp, $tok;
        } else { #операция
            my $arg2 = pop @exp;
            my $arg1 = pop @exp;
            my $op = "$arg1$tok$arg2";
            $op = "($op)" if $tok =~ /^[+-]$/;
            push @exp, $op;
        }
    }

    return @exp;
}
