#!/usr/bin/python
# -*- coding: utf-8 -*-

#поиск и печать категории в таблице эталонов
#python search_ctg.py 'Пластиковые и алюминиевые окна' 'окно пластиковый' (аргументы: 'категория' 'кластеризующая фраза')

import sys
import re
import math

import yt.wrapper as yt


#--- progress bar ---
def progress(count, total, status=''):
    bar_len = 60
    filled_len = int(round(bar_len * count / float(total)))

    percents = round(100.0 * count / float(total), 1)
    bar = '■' * filled_len + '-' * (bar_len - filled_len)

    sys.stderr.write('[%s] %s%s ...%s\r' % (bar, percents, '%', status))
    sys.stderr.flush()


#--- поиск первого баннера в категории ---
def bnr_search(table, mctgs, clast_phrase):
    input = table #исходная таблица
    row_count = yt.row_count(input)

    low = 0
    hi = row_count - 1
    steps = int(math.ceil(math.log(row_count, 2))) + 1 #число итераций в бинарном поиске
    step = 0;
    while low <= hi: #бинарный поиск урла в таблице
        mid = int((low + hi) / 2)
        input_range = input + '[#' + str(mid) + ':#' + str(mid+1) + ']' #прямой доступ к одной записи
        rec = next(yt.read_table(input_range, raw=False)) #итератор

        step += 1
        #------------------------------------------------
        progress(step, steps, status = 'Поиск в таблице')
        #------------------------------------------------

        if mctgs < rec['mctgs']:
            hi = mid - 1
        elif mctgs > rec['mctgs']:
            low = mid + 1
        elif clast_phrase < rec['clast_phrase']: #mctgs == rec['mctgs'], сравнение по второму полю
            hi = mid - 1
        elif clast_phrase > rec['clast_phrase']:
            low = mid + 1
        else: #совпадение
            if low < hi: #продолжение поиска для выбора ПЕРВОЙ записи ИЗ ГРУППЫ одинаковых
                hi = mid
            else:
                mid = hi #индекс ПЕРВОЙ записи в найденной ГРУППЕ записей с одинаковым доменом
                low = hi + 2 #ВЫХОД

    if low > row_count - 1:
        low = row_count - 1
    if hi < 0:
        hi = 0

    print >>sys.stderr
    if low == hi + 2: #поиск успешный
        input_range = input + '[#' + str(mid) + ':#' + str(mid+1) + ']' #прямой доступ к одной записи
        rec = next(yt.read_table(input_range, raw=False)) #итератор

        return mid #индекс найденной записи в таблице
    else:
        return low


#--- печать баннеров категории ---
def bnr_print(input, ind, clast_phrase):
    input_range = input + '[#' + str(ind) + ':]' #диапазон для просмотра таблицы от найденного места до конца

    flag = 0
    for rec in yt.read_table(input_range, raw=False):
        if clast_phrase != rec['clast_phrase']:
            break
        if flag == 0:
            flag = 1
            print 'КАТЕГОРИЯ: ' + rec['mctgs'] + '\tКЛАСТЕРИЗУЮЩАЯ ФРАЗА: ' + rec['clast_phrase']
        #print rec['mctgs'] + '\t' + rec['clast_phrase'] + '\t' + str(rec['bid']) + '\t' + rec['title'] + '\t' + rec['body']
        print '\t' + str(rec['bid']) + '\t' + rec['title'] + '\t' + rec['body']


def main():
    input = '//home/catalogia/users/yuryz/tmp/bnrs_norm_sense' #исходная таблица

    ind = bnr_search(input, sys.argv[1], sys.argv[2]) #поиск начала категории в таблице (sys.argv[1] - категория, sys.argv[2] - кластеризующая фраза)
    if ind < 0:
        return 1 #поиск неудачный

    bnr_print(input, ind, sys.argv[2]) #печать баннеров найденной категории с данной кластеризующей фразой


if __name__ == '__main__':
    main()
