#!/usr/bin/perl -w
#сжатие семантического ядра

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");


my $core_prev = ""; #предыдущее ядро
my $two_word_prev = ""; #предыдущее двусловие

while (<STDIN>) { #tree_test.txt
    chomp;

    my ($core, $ctg, $size, $trash) = split /\t/;

    my @tmp = split / /, $core;
    my $two_word = @tmp > 1 ? "$tmp[0] $tmp[1]" : $tmp[0];

    if ($two_word_prev eq "") {
        print "$_\n"; #первая запись двусловия ВСЕГДА выводится ЦЕЛИКОМ
        $two_word_prev = $two_word;
        $core_prev = $core;
    } elsif ($two_word_prev eq $two_word) {
        my @prev = split / /, $core_prev; #слова предыдущего ядра
        my @curr = split / /, $core; #слова текущего ядра

        my $n = @prev < @curr ? @prev+0 : @curr; #длина MIN из двух ядер
        my $k = 0; #общее число слов у предыдущего и текущего ядер
        for my $i (0..$n-1) {
            last if $prev[$i] ne $curr[$i];
            $k++;
        }

        for my $i (0..$#curr) {
            if ($i < $k ) {
                print "."; #очередной уровень
            } else {
                print join(" ", @curr[$i..$#curr]), "\t$ctg\t$size\t$trash\n";
                last;
            }
        }
        $core_prev = $core;
    } else {
        print "$_\n"; #первая запись двусловия ВСЕГДА выводится ЦЕЛИКОМ
        $two_word_prev = $two_word;
        $core_prev = $core;
    }
}
