#!/usr/bin/python
# -*- coding: utf-8 -*-

#ИССЛЕДОВАНИЕ: сжатие словаря wrd_ctg_tf_idf и его пересечение с word_filter

import yt.wrapper as yt


def word_compr(key, recs): #сжатие словаря wrd_ctg_tf_idf и его пересечение с word_filter
    ctgs = ''
    flag = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            flag = 1
        elif flag == 1:
            if ctgs != '':
                ctgs += '\t'
            #tf_idf = '%.3f' % (10000 * rec['tf_idf'])
            #ctgs += rec['mctgs'] + '\t' + str(tf_idf)
            ctgs = float('%.3f' % rec['idf'])
            break;
    if flag == 1:
        yield { "word": key['word'], "ctg_tf_idf": ctgs }


def main():
    tab1 = '//home/catalogia/users/yuryz/tmp/word_filter' # см. core_sense.sh
    tab2 = '//home/catalogia/users/yuryz/tmp/wrd_ctg_tf_idf' # см. tf_idf_3.py
    tab3 = '//tmp/yuryz/wrd_ctg_tf_idf'

    yt.run_reduce(word_compr, [tab1, tab2], tab3, reduce_by = ['word'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab3, sort_by=['word'])

    print yt.row_count(tab1)
    print yt.row_count(tab2)
    print yt.row_count(tab3)


if __name__ == '__main__':
    main()
