#!/usr/bin/perl -w
#первод дерева (в скобочной записи)в полные ветви и обратно

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';


#=== Развертка скобочной записи дерева в ветви ===
my $tree_bkt = "a(1,b(c,d),e)"; # скобочная запись дерева => a,abc,abd,ae
#tree2branch($tree_bkt); #получение полных ветвей дерева по его скобочной записи

#=== Построение дерева из ветвей ===
my $tree;
my @branch = ( "a 1", "a b c", "a b d", "a e" ); # => a(1,b(c,d),e)
@branch = ( "a b d", "a b e", "a b c k", "a b c n" ); # => a(b(d,e,c(k,n)))
for my $branch (@branch) { #создание дерева по его ветвям
    print "branch=[$branch]\n";
    $tree = branch2tree($tree, $branch); #вставка очередной ветви в дерево
    #print Dumper($tree), "\n";
}
#print Dumper($tree);

#=== Обход дерева в глубину и построение его (дерева) скобочной записи ===
DFS($tree);


# --- получение полных ветвей дерева по его скобочной записи (прямой обход в глубину) ---
sub tree2branch {
    my ($tree) = @_;
    print "$tree\n";

    my $name = "[^(),]+"; #имя
    my $re = "($name|[(),])"; #выделение токенов

    my @pref; #узлы дерева, предшествующие листу
    my $token_prev;
    while ($tree =~ /$re/g) {
        my $token = $1;
        if ($token eq "(") {
            push @pref, $token_prev; #увеличение уровня
        } elsif ($token =~ /^[,)]$/) {
            print join(" ", @pref), " $token_prev\n" if $token_prev ne ")";
            if ($token eq ")") {
                pop @pref; #уменьшение уровня
            }
        }
        $token_prev = $token;
    }
}


# --- вставка очередной ветви в дерево ---
sub branch2tree {
    my ($tree, $branch) = @_;

    my @nodes = split / /, $branch; #узлы очередной ветви
    my $root = $tree;
    for my $i (0..$#nodes) {
        if ($i == 0) { #корневой узел
            unless ($tree) { #вставляем корень дерева
                $tree = new_node($nodes[0], undef, undef, undef); #указатели: <VALUE, LEFT, UP, DOWN>
                $root = $tree;
            } else {
                last if $tree->{VALUE} ne $nodes[0]; #корень у дерева д.б. один
            }
        } else { #некорневые узлы
            unless ($tree->{DOWN}) { #подузлов нет, вставляем первый подузел в начало цепочки подузлов
                $tree->{DOWN} = new_node($nodes[$i], undef, $tree, undef);
                $tree = $tree->{DOWN}; #переходим к вставленному подузлу
            } else {
                $tree = $tree->{DOWN}; #выбираем первый подузел
                while ($tree->{VALUE} ne $nodes[$i]) { #перебираем справа налево подузлы на совпадение с новым вставляемым подузлом $nodes[$i]
                    last unless $tree->{LEFT};
                    $tree = $tree->{LEFT}; #собственно перебор (при совпадении $tree->{VALUE} с $nodes[$i], после выхода из цикла $tree указывает на совпавший с $nodes[$i] подузел)
                }

                if ($tree->{VALUE} ne $nodes[$i]) { #если совпадения $tree->{VALUE} с $nodes[$i] не обнаружено, то вставляем новый подузел $nodes[$i] в левый конец цепочки подузлов
                    $tree->{LEFT} = new_node($nodes[$i], undef, $tree->{UP}, undef);
                    $tree = $tree->{LEFT}; #переходим к вставленному подузлу
                }
            }
        }
    }

    return $root;
}


#--- создание нового узла ---
sub new_node {
    my ($value, $left, $up, $down) = @_;

    my $node = {};
    $node->{VALUE}  = $value;
    $node->{LEFT}   = $left;
    $node->{UP}  = $up;
    $node->{DOWN}  = $down;

    return $node;
}


#--- обход дерева в глубину и построение его (дерева) скобочной записи ---
sub DFS {
    my ($tree) = @_;

    my $node = $tree; #корень дерева
    my @branch = ( $node->{VALUE} );
    my $tree_view = "$node->{VALUE}"; #скобочное представление дерева ( a(1,b(c,d),e) )
    while () {
        if ($node->{DOWN}) { #на уровень вниз
            $node = $node->{DOWN};
            push @branch, $node->{VALUE};
            $tree_view .= "($node->{VALUE}"; ###
        } else { #достигли листа
            print join(" ", @branch), "\n"; #печать очередной ветви
            pop @branch;
            if ($node->{LEFT}) { #обработка подузлов текущего узла
                $node = $node->{LEFT};
                push @branch, $node->{VALUE};
                $tree_view .= ",$node->{VALUE}"; ###
            } else { #узел с подузлами обработан
                pop @branch;
                while ($node = $node->{UP}) { #на уровень вверх
                    $tree_view .= ")"; ###
                    if ($node->{LEFT}) { #обработка следующего узла на одном из верхних уровней
                        $node = $node->{LEFT};
                        push @branch, $node->{VALUE};
                        $tree_view .= ",$node->{VALUE}"; ###
                        last;
                    }
                }
                last unless $node; #достигли корня - выход из цикла
            }
        }
    }

    print "$tree_view\n";
}
