#!/usr/bin/python
# -*- coding: utf-8 -*-

#поиск и печать категории в таблице эталонов

import sys
import re
import math

import yt.wrapper as yt


#--- progress bar ---
def progress(count, total, status=''):
    bar_len = 60
    filled_len = int(round(bar_len * count / float(total)))

    percents = round(100.0 * count / float(total), 1)
    bar = '■' * filled_len + '-' * (bar_len - filled_len)

    sys.stderr.write('[%s] %s%s ...%s\r' % (bar, percents, '%', status))
    sys.stderr.flush()


#--- поиск первого баннера в категории ---
def bnr_search(table, mctgs, rank_max):
    input = table #исходная таблица
    row_count = yt.row_count(input)

    rank_sel = -float(rank_max) #минус, т.к. YT упорядочивает по убыванию положительные числа как отрицательные по возрастанию

    low = 0
    hi = row_count - 1
    steps = int(math.ceil(math.log(row_count, 2))) + 1 #число итераций в бинарном поиске
    step = 0;
    while low <= hi: #бинарный поиск урла в таблице
        mid = int((low + hi) / 2)
        input_range = input + '[#' + str(mid) + ':#' + str(mid+1) + ']' #прямой доступ к одной записи
        rec = next(yt.read_table(input_range, raw=False)) #итератор

        step += 1
        #------------------------------------------------
        progress(step, steps, status = 'Поиск в таблице')
        #------------------------------------------------

        if mctgs < rec['mctgs']:
            hi = mid - 1
        elif mctgs > rec['mctgs']:
            low = mid + 1
        elif rank_sel < rec['rank_rel']: #mctgs == rec['mctgs'], сравнение по второму полю
            hi = mid - 1
        elif rank_sel > rec['rank_rel']:
            low = mid + 1
        else: #совпадение
            if low < hi: #продолжение поиска для выбора ПЕРВОЙ записи ИЗ ГРУППЫ одинаковых
                hi = mid
            else:
                mid = hi #индекс ПЕРВОЙ записи в найденной ГРУППЕ записей с одинаковым доменом
                low = hi + 2 #ВЫХОД

    if low > row_count - 1:
        low = row_count - 1
    if hi < 0:
        hi = 0

    print >>sys.stderr
    if low == hi + 2: #поиск успешный
        input_range = input + '[#' + str(mid) + ':#' + str(mid+1) + ']' #прямой доступ к одной записи
        rec = next(yt.read_table(input_range, raw=False)) #итератор

        return mid #индекс найденной записи в таблице
    else:
        return low


#--- печать баннеров категории ---
def bnr_print(input, ind, total):
    input_range = input + '[#' + str(ind) + ':]' #диапазон для просмотра таблицы от найденного места до конца

    bnr_cnt = 0
    for rec in yt.read_table(input_range, raw=False):
        print rec['mctgs'] + '\t' + str(rec['bid']) + '\t' + rec['title'] + '\t' + rec['body']+ '\t' + str(-rec['rank_rel']) + '\t' + str(-rec['size'])
        bnr_cnt += 1
        if bnr_cnt >= int(total):
            break


def main():
    input = '//home/catalogia/users/yuryz/bnrs_rank_rel_s' #исходная таблица

    ind = bnr_search(input, sys.argv[1], sys.argv[2]) #поиск начала категории в таблице (sys.argv[1] - категория, sys.argv[2] - максимальный ранг)
    if ind < 0:
        return 1 #поиск неудачный

    bnr_print(input, ind, sys.argv[3]) #печать баннеров найденной категории (sys.argv[3] - число баннеров для печати)


if __name__ == '__main__':
    main()
